/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.awt.Color;
import java.io.PrintStream;
import org.das2.math.Edge;
import org.das2.math.Panic;
import org.das2.math.RealPoint;
import org.das2.math.RealWindow;
import org.das2.math.RealWindowGraphics;

class Triangulation {
    static final int Undefined = -1;
    static final int Universe = 0;
    int nPoints;
    RealPoint[] point;
    int nEdges;
    int maxEdges;
    Edge[] edge;

    Triangulation(int nPoints) {
        int i;
        this.nPoints = nPoints;
        this.point = new RealPoint[nPoints];
        for (i = 0; i < nPoints; ++i) {
            this.point[i] = new RealPoint();
        }
        this.maxEdges = 3 * nPoints - 6;
        this.edge = new Edge[this.maxEdges];
        for (i = 0; i < this.maxEdges; ++i) {
            this.edge[i] = new Edge();
        }
        this.nEdges = 0;
    }

    public void setNPoints(int nPoints) {
        int i;
        int i2;
        Edge[] tmpEdge = this.edge;
        int tmpMaxEdges = this.maxEdges;
        this.maxEdges = 3 * nPoints - 6;
        this.edge = new Edge[this.maxEdges];
        int minMaxEdges = tmpMaxEdges < this.maxEdges ? tmpMaxEdges : this.maxEdges;
        for (i2 = 0; i2 < minMaxEdges; ++i2) {
            this.edge[i2] = tmpEdge[i2];
        }
        for (i2 = minMaxEdges; i2 < this.maxEdges; ++i2) {
            this.edge[i2] = new Edge();
        }
        RealPoint[] tmpPoint = this.point;
        this.point = new RealPoint[nPoints];
        int minPoints = nPoints < this.nPoints ? nPoints : this.nPoints;
        for (i = 0; i < minPoints; ++i) {
            this.point[i] = tmpPoint[i];
        }
        for (i = minPoints; i < nPoints; ++i) {
            this.point[i] = new RealPoint();
        }
        this.nPoints = nPoints;
    }

    public void randomPoints(RealWindow w) {
        for (int i = 0; i < this.nPoints; ++i) {
            this.point[i].x = (float)Math.random() * w.xMax();
            this.point[i].y = (float)Math.random() * w.yMax();
        }
        this.nEdges = 0;
    }

    public void copyPoints(Triangulation t) {
        int n = t.nPoints < this.nPoints ? t.nPoints : this.nPoints;
        for (int i = 0; i < n; ++i) {
            this.point[i].x = t.point[i].x;
            this.point[i].y = t.point[i].y;
        }
        this.nEdges = 0;
    }

    void addTriangle(int s, int t, int u) {
        this.addEdge(s, t);
        this.addEdge(t, u);
        this.addEdge(u, s);
    }

    public int addEdge(int s, int t) {
        return this.addEdge(s, t, -1, -1);
    }

    public int addEdge(int s, int t, int l, int r) {
        int e = this.findEdge(s, t);
        if (e == -1) {
            if (s < t) {
                this.edge[this.nEdges].s = s;
                this.edge[this.nEdges].t = t;
                this.edge[this.nEdges].l = l;
                this.edge[this.nEdges].r = r;
                return this.nEdges++;
            }
            this.edge[this.nEdges].s = t;
            this.edge[this.nEdges].t = s;
            this.edge[this.nEdges].l = r;
            this.edge[this.nEdges].r = l;
            return this.nEdges++;
        }
        return -1;
    }

    public int findEdge(int s, int t) {
        int i;
        boolean edgeExists = false;
        for (i = 0; i < this.nEdges; ++i) {
            if ((this.edge[i].s != s || this.edge[i].t != t) && (this.edge[i].s != t || this.edge[i].t != s)) continue;
            edgeExists = true;
            break;
        }
        if (edgeExists) {
            return i;
        }
        return -1;
    }

    public void updateLeftFace(int eI, int s, int t, int f) {
        if (!(this.edge[eI].s == s && this.edge[eI].t == t || this.edge[eI].s == t && this.edge[eI].t == s)) {
            Panic.panic("updateLeftFace: adj. matrix and edge table mismatch");
        }
        if (this.edge[eI].s == s && this.edge[eI].l == -1) {
            this.edge[eI].l = f;
        } else if (this.edge[eI].t == s && this.edge[eI].r == -1) {
            this.edge[eI].r = f;
        } else {
            Panic.panic("updateLeftFace: attempt to overwrite edge info");
        }
    }

    public void draw(RealWindowGraphics rWG, Color pC, Color eC) {
        this.drawPoints(rWG, pC);
        this.drawEdges(rWG, eC);
    }

    public void drawPoints(RealWindowGraphics rWG, Color c) {
        for (int i = 0; i < this.nPoints; ++i) {
            rWG.drawPoint(this.point[i], c);
        }
    }

    public void drawEdges(RealWindowGraphics rWG, Color c) {
        for (int i = 0; i < this.nEdges; ++i) {
            this.drawEdge(rWG, this.edge[i], c);
        }
    }

    public void drawEdge(RealWindowGraphics rWG, Edge e, Color c) {
        rWG.drawLine(this.point[e.s], this.point[e.t], c);
    }

    public void print(PrintStream p) {
        this.printPoints(p);
        this.printEdges(p);
    }

    public void printPoints(PrintStream p) {
        for (int i = 0; i < this.nPoints; ++i) {
            p.println(String.valueOf(this.point[i].x) + " " + String.valueOf(this.point[i].y));
        }
    }

    public void printEdges(PrintStream p) {
        for (int i = 0; i < this.nEdges; ++i) {
            p.println(String.valueOf(this.edge[i].s) + " " + String.valueOf(this.edge[i].t));
        }
    }
}

