/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft.jnt;

import org.das2.math.fft.ComplexArray;

public abstract class RealDoubleFFT {
    int n;

    public RealDoubleFFT(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The transform length must be >=0 : " + n);
        }
        this.n = n;
    }

    protected void checkData(double[] data, int i0, int stride) {
        if (i0 < 0) {
            throw new IllegalArgumentException("The offset must be >=0 : " + i0);
        }
        if (stride < 1) {
            throw new IllegalArgumentException("The stride must be >=1 : " + stride);
        }
        if (i0 + stride * (this.n - 1) + 1 > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.n + ":" + "i0=" + i0 + " stride=" + stride + " data.length=" + data.length);
        }
    }

    public void transform(ComplexArray.Double data) {
        this.transform(data, 0, 1);
    }

    public abstract void transform(ComplexArray.Double var1, int var2, int var3);

    public void backtransform(ComplexArray.Double data) {
        this.backtransform(data, 0, 1);
    }

    public abstract void backtransform(ComplexArray.Double var1, int var2, int var3);

    public double normalization() {
        return 1.0 / (double)this.n;
    }

    public void inverse(ComplexArray.Double data) {
        this.inverse(data, 0, 1);
    }

    public void inverse(ComplexArray.Double data, int i0, int stride) {
        this.backtransform(data, i0, stride);
        double norm = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            data.setReal(i, data.getReal(i) * norm);
            data.setImag(i, data.getImag(i) * norm);
        }
    }
}

