/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class ChangesSupport {
    Map<Object, Object> changesPending;
    Object parent;
    private static final Logger logger = Logger.getLogger("dom");
    public static final String PROP_PENDINGCHANGES = "pendingChanges";
    public static final String PROP_VALUEADJUSTING = "valueAdjusting";
    private boolean valueIsAdjusting = false;
    private Lock mutatorLock = new ReentrantLock(){

        public void lock() {
            super.lock();
            if (!ChangesSupport.this.valueIsAdjusting) {
                ChangesSupport.this.propertyChangeSupport.firePropertyChange(ChangesSupport.PROP_VALUEADJUSTING, false, true);
                ChangesSupport.this.valueIsAdjusting = true;
            }
        }

        public void unlock() {
            super.unlock();
            if (!super.isLocked()) {
                ChangesSupport.this.valueIsAdjusting = false;
                ChangesSupport.this.propertyChangeSupport.firePropertyChange(ChangesSupport.PROP_VALUEADJUSTING, true, false);
            }
        }
    };
    private PropertyChangeSupport propertyChangeSupport;

    public ChangesSupport(PropertyChangeSupport pcs, Object parent) {
        this.parent = parent;
        this.changesPending = new HashMap<Object, Object>();
        if (pcs == null) {
            pcs = new PropertyChangeSupport(parent);
        }
        this.propertyChangeSupport = pcs;
    }

    public synchronized void registerPendingChange(Object client, Object lockObject) {
        String msg = "registerPendingChange " + lockObject + " by " + client + "  in " + this.parent;
        logger.fine(msg);
        Object existingClient = this.changesPending.get(lockObject);
        if (existingClient != null) {
            if (existingClient != client) {
                throw new IllegalStateException("lock object in use: " + lockObject + ", by " + this.changesPending.get(lockObject));
            }
            return;
        }
        boolean oldVal = this.isPendingChanges();
        this.changesPending.put(lockObject, client);
        this.propertyChangeSupport.firePropertyChange(PROP_PENDINGCHANGES, oldVal, true);
    }

    public synchronized void performingChange(Object client, Object lockObject) {
        Object c = this.changesPending.get(lockObject);
        if (c == null || c != client) {
            this.registerPendingChange(client, lockObject);
        }
        logger.fine("performingChange " + lockObject + " by " + client + "  in " + this.parent);
    }

    public synchronized void changePerformed(Object client, Object lockObject) {
        logger.fine("clearPendingChange " + lockObject + " by " + client + "  in " + this.parent);
        if (this.changesPending.get(lockObject) == null) {
            // empty if block
        }
        boolean oldVal = this.isPendingChanges();
        this.changesPending.remove(lockObject);
        this.propertyChangeSupport.firePropertyChange(PROP_PENDINGCHANGES, oldVal, true);
    }

    public boolean isPendingChanges() {
        return this.changesPending.size() > 0;
    }

    public boolean isValueAdjusting() {
        return this.valueIsAdjusting;
    }

    public synchronized Lock mutatorLock() {
        return this.mutatorLock;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

