/*
 * Decompiled with CFR 0.152.
 */
package test.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import org.das2.client.DataSetStreamHandler;
import org.das2.components.DasProgressPanel;
import org.das2.dataset.DataSet;
import org.das2.stream.StreamException;
import org.das2.stream.StreamTool;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class TestDas2StreamRead {
    public static void main(String[] args) throws Exception {
        URL dataUrl = new URL("http://www-wbd.physics.uiowa.edu/das/das2Server?server=dataset&start_time=2007-04-17T08%3A40%3A00.000Z&end_time=2007-04-17T08%3A50%3A00.000Z&resolution=1.1695906432748537&dataset=das2_1%2Fcluster%2Fwbd%2Fr_wbd_wf&params=sc%3D2%26ant%3DEz%26fo%3Dx");
        long t0 = System.currentTimeMillis();
        DasProgressPanel mon = DasProgressPanel.createFramed("reading data");
        DataSet ds = TestDas2StreamRead.getDataSet(dataUrl, mon);
        long dt = System.currentTimeMillis() - t0;
        System.err.println("done in " + dt + " millis");
        File f = new File(dataUrl.getPath());
        long taskSize = f.length() > 0L ? f.length() : -1L;
        System.err.println("  " + taskSize / dt + " Kb/s");
        t0 = System.currentTimeMillis();
        mon = DasProgressPanel.createFramed("reading data");
        TestDas2StreamRead.eatData(dataUrl, mon);
        long dt2 = System.currentTimeMillis() - t0;
        System.err.println("done in " + dt2 + " millis");
        File f2 = new File(dataUrl.getPath());
        long taskSize2 = f2.length() > 0L ? f2.length() : -1L;
        System.err.println("  " + taskSize2 / dt2 + " Kb/s");
    }

    public static void eatData(URL url, ProgressMonitor mon) throws IOException {
        long taskSize = -1L;
        URLConnection connect = url.openConnection();
        InputStream in = connect.getInputStream();
        System.err.println("reading data from " + url);
        if (connect instanceof HttpURLConnection) {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            taskSize = connection.getContentLength();
        } else {
            File f;
            taskSize = url.getProtocol().equals("file") ? ((f = new File(url.getPath())).length() > 0L ? f.length() : -1L) : -1L;
        }
        System.err.println("  taskSize=" + taskSize);
        DasProgressMonitorInputStream min = new DasProgressMonitorInputStream(in, mon);
        min.setStreamLength(taskSize);
        in = min;
        DataSetStreamHandler handler = new DataSetStreamHandler(new HashMap(), (ProgressMonitor)new NullProgressMonitor());
        ReadableByteChannel channel = Channels.newChannel(in);
        ByteBuffer buf = ByteBuffer.allocateDirect(84);
        int bytesRead = 84;
        while (bytesRead == 84) {
            bytesRead = channel.read(buf);
            buf.position(4);
            DoubleBuffer dbuf = buf.slice().asDoubleBuffer();
            for (int i = 0; i < 10; ++i) {
                double d = dbuf.get(i);
            }
            buf.position(0);
        }
        in.close();
    }

    public static DataSet getDataSet(URL url, ProgressMonitor mon) throws IOException, StreamException {
        long taskSize = -1L;
        URLConnection connect = url.openConnection();
        InputStream in = connect.getInputStream();
        System.err.println("reading data from " + url);
        if (connect instanceof HttpURLConnection) {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            taskSize = connection.getContentLength();
        } else {
            File f;
            taskSize = url.getProtocol().equals("file") ? ((f = new File(url.getPath())).length() > 0L ? f.length() : -1L) : -1L;
        }
        System.err.println("  taskSize=" + taskSize);
        DasProgressMonitorInputStream min = new DasProgressMonitorInputStream(in, mon);
        min.setStreamLength(taskSize);
        in = min;
        DataSetStreamHandler handler = new DataSetStreamHandler(new HashMap(), (ProgressMonitor)new NullProgressMonitor());
        ReadableByteChannel channel = Channels.newChannel(in);
        StreamTool.readStream(channel, handler);
        in.close();
        return handler.getDataSet();
    }
}

