/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AggregatingDataSourceEditorPanel.java
 *
 * Created on Apr 22, 2009, 8:37:48 AM
 */

package org.virbo.cdfdatasource;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.util.DasExceptionHandler;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;

/**
 *
 * @author jbf
 */
public class CdfDataSourceEditorPanel extends javax.swing.JPanel implements DataSourceEditorPanel {
    private final static Logger logger= Logger.getLogger( CdfDataSourceEditorPanel.class.getCanonicalName() );

    /** Creates new form AggregatingDataSourceEditorPanel */
    public CdfDataSourceEditorPanel() {
        initComponents();
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this, "cdf_main");
        parameterList.addListSelectionListener( new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if ( e.getValueIsAdjusting() ) return;
            }
        } );
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        parameterList = new javax.swing.JList();
        jPanel3 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        subsetComboBox = new javax.swing.JComboBox();
        interpretMetadataLabel = new javax.swing.JLabel();
        noInterpMeta = new javax.swing.JCheckBox();
        noDep = new javax.swing.JCheckBox();
        showAllVarTypeCB = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        paramInfo = new javax.swing.JLabel();

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel1.setText("Select CDF Variable:");

        parameterList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        parameterList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        parameterList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                parameterListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(parameterList);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Advanced"));

        jLabel3.setText("Load subset of the data:");
        jLabel3.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");

        subsetComboBox.setEditable(true);
        subsetComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "::10", "0:100", "-100:", "0:10000:5" }));
        subsetComboBox.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");

        interpretMetadataLabel.setText("Interpret Metadata:");

        noInterpMeta.setText("no ISTP");
        noInterpMeta.setToolTipText("Don't interpret metadata to get titles and units.");

        noDep.setText("no dependencies");
        noDep.setToolTipText("Ignore connections between variables like \"DEPEND_0\"\n");

        showAllVarTypeCB.setText("show all");
        showAllVarTypeCB.setToolTipText("show all parameters, even if ISTP VAR_TYPE is not \"data\"");
        showAllVarTypeCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showAllVarTypeCBActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(interpretMetadataLabel)
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(noDep)
                            .add(noInterpMeta)
                            .add(showAllVarTypeCB)))
                    .add(jLabel3)
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(subsetComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 160, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(jLabel3)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(subsetComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(interpretMetadataLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(noInterpMeta)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(noDep)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(showAllVarTypeCB)
                .addContainerGap(45, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 193, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(6, 6, 6)
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 379, Short.MAX_VALUE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 229, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        paramInfo.setText("Variable");

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(paramInfo, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 611, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(paramInfo)
                .addContainerGap(70, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void parameterListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_parameterListValueChanged
        this.parameter= (String) parameterList.getSelectedValue();
        updateMetadata();
    }//GEN-LAST:event_parameterListValueChanged

    private void showAllVarTypeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showAllVarTypeCBActionPerformed
        setURI( getURI() );
    }//GEN-LAST:event_showAllVarTypeCBActionPerformed

    private void updateMetadata() {
       String longName= parameterInfo.get(parameter);
       paramInfo.setText( longName );
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel interpretMetadataLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JCheckBox noDep;
    private javax.swing.JCheckBox noInterpMeta;
    private javax.swing.JLabel paramInfo;
    private javax.swing.JList parameterList;
    private javax.swing.JCheckBox showAllVarTypeCB;
    private javax.swing.JComboBox subsetComboBox;
    // End of variables declaration//GEN-END:variables

    public JPanel getPanel() {
        return this;
    }


    JComponent delegateComponent = null;
    DataSetSelector delegateDataSetSelector=null;
    DataSourceEditorPanel delegateEditorPanel= null;
    URISplit split;
    /**
     * URI parameters
     */
    Map<String,String> params;

    /**
     * short descriptions of the parameters
     */
    Map<String,String> parameterDescriptions;

    /**
     * long descriptions html formatted metadata about each parameter.
     */
    Map<String,String> parameterInfo;

    String parameter;

    /**
     * can I reuse the slice?  Only if the maxRec doesn't change.
     */
    long subsetMaxRec=-1;

    File cdfFile;

    /**
     * allow more abstract sources, namely cdaweb, to turn off these controls.
     * @param v
     */
    public void setShowAdvancedSubpanel( boolean v ) {
        interpretMetadataLabel.setVisible(v);
        noDep.setVisible(v);
        noInterpMeta.setVisible(v);
    }

    public boolean reject( String url ) throws IOException, URISyntaxException {
        split = URISplit.parse(url);
        FileSystem fs = FileSystem.create( DataSetURI.getWebURL( DataSetURI.toUri(split.path) ).toURI() );
        if ( fs.isDirectory( split.file.substring(split.path.length()) ) ) {
            return true;
        }
        return false;
    }

    public boolean prepare( String url,  java.awt.Window parent, ProgressMonitor mon) throws Exception {
        split= URISplit.parse(url);

        cdfFile= DataSetURI.getFile( split.resourceUri.toURL(), mon );

        return true;
    }

    public void setURI(String url) {
        split= URISplit.parse(url);
        params= URISplit.parseParams(split.params);

        try {

            cdfFile= DataSetURI.getFile( split.resourceUri.toURL(), new NullProgressMonitor() );
            
            String fileName= cdfFile.toString();

            logger.fine("opening cdf file "+fileName);
            CDF cdf= CdfFileDataSourceFactory.getCDFFile( fileName );

            logger.finest("inspect cdf for plottable parameters");
            parameterDescriptions= CdfUtil.getPlottable( cdf, !showAllVarTypeCB.isSelected(), QDataSet.MAX_RANK, false );
            parameterInfo= CdfUtil.getPlottable( cdf, !showAllVarTypeCB.isSelected(), QDataSet.MAX_RANK, true );
            if ( parameterDescriptions.isEmpty() ) {
                throw new IllegalArgumentException("no plottable parameters in cdf file!");
            }

            logger.finest("close cdf");
            CdfFileDataSourceFactory.closeCDF(cdf);

            DefaultListModel model= new DefaultListModel();
            DefaultComboBoxModel cbmodel= new DefaultComboBoxModel();
            for ( String p: parameterDescriptions.keySet() ) {
                model.addElement(p);
                cbmodel.addElement(p);
            }
            parameterList.setModel( model );

            String param= params.get("arg_0");
            if ( param!=null ) {
                int i= param.indexOf("[");
                if ( i!=-1 ) {
                    subsetComboBox.setSelectedItem( param.substring(i) );
                    param= param.substring(0,i);
                } else {
                    subsetComboBox.setSelectedItem("");
                }
                parameterList.setSelectedValue(param, true);
            } else {
                parameter= parameterDescriptions.entrySet().iterator().next().getKey();
                parameterList.setSelectedValue( parameter, true );
                subsetComboBox.setSelectedItem("");
                param= parameter;
            }
            parameter= param.replaceAll("%3D", "=");

            if ( "no".equals( params.get("interpMeta")) ) {
                noInterpMeta.setSelected(true);
            }

            if ( "no".equals( params.get("doDep" ) ) ) {
                noDep.setSelected(true);
            }

        } catch (CDFException ex) {
            DasExceptionHandler.handle( ex );
        } catch (IOException ex) {
            DasExceptionHandler.handle( ex );
            Logger.getLogger(CdfDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IllegalArgumentException ex) {
            DasExceptionHandler.handle( ex );
            Logger.getLogger(CdfDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public String getURI() {
        String slice= subsetComboBox.getSelectedItem().toString().trim();
        if ( slice.length()>0 && slice.charAt(0)!='[' ) {
            slice= "["+slice+"]";
        }
        String p = parameter;
        if ( p!=null ) { 
            p= p.replaceAll("=", "%3D");
            params.put( "arg_0", p + ( slice==null ? "" : slice ) );
        } else {
            System.err.println("param was null");
        }
            
        if ( noDep.isSelected() ) {
            params.put("doDep","no");
        } else {
            params.remove("doDep");
        }
        if ( noInterpMeta.isSelected() ) {
            params.put("interpMeta", "no");
        } else {
            params.remove("interpMeta");
        }
        
        split.params= URISplit.formatParams(params);
        return URISplit.format(split);
    }

}
