/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * Das2ServerDataSourceEditorPanel.java
 *
 * Created on Oct 16, 2009, 12:59:27 PM
 */

package org.das2.datasource;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.client.DasServer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author jbf
 */
public class Das2ServerDataSourceEditorPanel extends javax.swing.JPanel implements DataSourceEditorPanel {

    private String DEFAULT_TIMERANGE="2001-01-01";

    /** Creates new form Das2ServerDataSourceEditorPanel */
    public Das2ServerDataSourceEditorPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jComboBox1 = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();
        jLabel2 = new javax.swing.JLabel();
        timeRangeTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        ReaderParamsTextArea = new javax.swing.JTextArea();
        jLabel5 = new javax.swing.JLabel();
        tcaTextField = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        tcaItem = new javax.swing.JTextField();
        viewDsdfButton = new javax.swing.JButton();
        validRangeLabel = new javax.swing.JLabel();
        discoveryCb = new javax.swing.JCheckBox();
        examplesComboBox = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        descriptionLabel = new javax.swing.JLabel();

        jComboBox1.setEditable(true);
        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "http://www-pw.physics.uiowa.edu/das/das2Server", "http://cassini.physics.uiowa.edu/das/das2Server" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        jLabel1.setText("Das2 Server URL:");

        javax.swing.tree.DefaultMutableTreeNode treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("Loading DataSets List...");
        jTree1.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
        jTree1.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                jTree1ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jTree1);

        jLabel2.setText("Data Set Id:");

        timeRangeTextField.setText("2000-01-01");

        jLabel3.setText("Time Range:");

        jLabel4.setText("Reader Parameters:");

        ReaderParamsTextArea.setColumns(20);
        ReaderParamsTextArea.setRows(5);
        jScrollPane2.setViewportView(ReaderParamsTextArea);

        jLabel5.setText("TCA Interval (sec):");
        jLabel5.setToolTipText("<html>\nInterval (in seconds) to use for TCA (ephemeris) data.<br>\nLeave blank for most datasets.<br>\n</html>\n");

        tcaTextField.setText(" ");
        tcaTextField.setToolTipText("<html> Interval (in seconds) to use for TCA (ephemeris) data.<br> Leave blank for most datasets.<br> </html> ");

        jLabel6.setText("TCA Item:");
        jLabel6.setToolTipText("The optional item number for TCAs.");

        tcaItem.setToolTipText("The optional item number for TCAs.");

        viewDsdfButton.setText("View DSDF");
        viewDsdfButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewDsdfButtonActionPerformed(evt);
            }
        });

        validRangeLabel.setFont(new java.awt.Font("DejaVu LGC Sans", 0, 10));
        validRangeLabel.setText("<html><em>no valid range for dataset provided</em></html>");

        discoveryCb.setText("require example time");
        discoveryCb.setToolTipText("Show only datasets that have identified example times.");
        discoveryCb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                discoveryCbActionPerformed(evt);
            }
        });

        examplesComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Examples", " " }));
        examplesComboBox.setToolTipText("Example times specified in the data set descriptor file");
        examplesComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                examplesComboBoxActionPerformed(evt);
            }
        });

        jLabel7.setText("Description:");

        descriptionLabel.setText(" ");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 412, Short.MAX_VALUE)
                            .add(jComboBox1, 0, 412, Short.MAX_VALUE)
                            .add(jLabel1)
                            .add(layout.createSequentialGroup()
                                .add(jLabel2)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 177, Short.MAX_VALUE)
                                .add(discoveryCb))))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel5)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(tcaTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 70, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jLabel6)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(tcaItem, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 42, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel4))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(33, 33, 33)
                        .add(validRangeLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 234, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(examplesComboBox, 0, 145, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel7)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(descriptionLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 330, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel3)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(timeRangeTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(viewDsdfButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jComboBox1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(5, 5, 5)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(discoveryCb))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 94, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel7)
                    .add(descriptionLabel))
                .add(7, 7, 7)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(timeRangeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(viewDsdfButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(validRangeLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(examplesComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel4)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 65, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(tcaTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel6)
                    .add(tcaItem, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jTree1ValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_jTree1ValueChanged
        TreePath p= evt.getPath();
        TreeModel m= ((JTree)evt.getSource()).getModel();
        if ( ! m.isLeaf( p.getLastPathComponent() ) ) {
            descriptionLabel.setText( "" );
            this.validRangeLabel.setText("<html><em>no dataset selected</em></html>");
            this.viewDsdfButton.setEnabled(false);
        } else {
            this.viewDsdfButton.setEnabled(true);
            this.validRangeLabel.setText("<html><em>retrieving dataset info...</em></html>");
            Object[] oo= p.getPath();
            String ds= String.valueOf( oo[1] );
            for ( int i=2; i<oo.length; i++ ) {
                ds= ds + "/" + oo[i];
            }
            String surl = oo[0] + "?server=dsdf&dataset=" + ds;
            {
                InputStream in = null;
                try {
                    URL url = new URL(surl);
                    in = url.openStream();
                    StringBuilder sb = new StringBuilder();
                    int by = in.read();
                    while (by != -1) {
                        sb.append((char) by);
                        by = in.read();
                    }
                    in.close();
                    String s = sb.toString();
                    int contentLength = Integer.parseInt(s.substring(4, 10));
                    String sxml = s.substring(10, 10 + contentLength);
                    Reader xin = new BufferedReader(new StringReader(sxml));
                    DocumentBuilder builder;
                    builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    InputSource source = new InputSource(xin);
                    Document document = builder.parse(source);
                    XPathFactory factory = XPathFactory.newInstance();
                    XPath xpath = (XPath) factory.newXPath();

                    String curr= this.timeRangeTextField.getText();

                    Node description= (Node) xpath.evaluate( "/stream/properties/@description", document, XPathConstants.NODE );
                    descriptionLabel.setText( description==null ? "" : description.getNodeValue() );

                    Node exampleRange= (Node) xpath.evaluate( "/stream/properties/@exampleRange", document, XPathConstants.NODE );
                    if ( exampleRange!=null && curr.equals(DEFAULT_TIMERANGE) ) {
                        this.timeRangeTextField.setText( exampleRange.getNodeValue() );
                    }
                    if ( exampleRange!=null ) {
                        DefaultComboBoxModel model= new DefaultComboBoxModel( new String[] { "Examples", exampleRange.getNodeValue() } );
                        this.examplesComboBox.setModel( model );
                        this.examplesComboBox.setEnabled(true);
                    } else {
                        DefaultComboBoxModel model= new DefaultComboBoxModel( new String[] { "Examples" } );
                        this.examplesComboBox.setModel( model );
                        this.examplesComboBox.setEnabled(false);
                    }

                    if ( exampleRange==null ) {
                        exampleRange= (Node) xpath.evaluate( "/stream/properties/@x_range", document, XPathConstants.NODE );
                        if ( exampleRange!=null && curr.equals(DEFAULT_TIMERANGE) ) {
                            this.timeRangeTextField.setText( exampleRange.getNodeValue() );
                        }
                    }
                    Node validRange= (Node)  xpath.evaluate( "/stream/properties/@validRange", document, XPathConstants.NODE );
                    if ( validRange!=null ) {
                        this.validRangeLabel.setText( "valid range: " + validRange.getNodeValue() );
                    } else {
                        this.validRangeLabel.setText("<html><em>no valid range for dataset provided</em></html>");
                    }
                } catch (XPathExpressionException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } catch (SAXException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } catch (ParserConfigurationException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } catch (MalformedURLException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } finally {
                    try {
                        in.close();
                    } catch (IOException ex) {
                        Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            
        }
    }//GEN-LAST:event_jTree1ValueChanged

    private void viewDsdfButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_viewDsdfButtonActionPerformed
        TreePath p= jTree1.getSelectionPath();
        TreeModel m= jTree1.getModel();
        if ( m.isLeaf( p.getLastPathComponent() ) ) {
            {
                InputStream in = null;
                try {
                    Object[] oo = p.getPath();
                    String ds = String.valueOf(oo[1]);
                    for (int i = 2; i < oo.length; i++) {
                        ds = ds + "/" + oo[i];
                    }
                    String surl = oo[0] + "?server=dsdf&dataset=" + ds;
                    URL url = new URL(surl);
                    
                    in = url.openStream();

                    StringBuilder sb= new StringBuilder();

                    int by= in.read();
                    while ( by!=-1 ) {
                        sb.append( (char)by );
                        by= in.read();
                    }
                    in.close();

                    String s= sb.toString();
                    int contentLength= Integer.parseInt( s.substring(4,10) );
                    String sxml= s.substring(10,10+contentLength);

                    Reader xin = new BufferedReader(new StringReader(sxml));

                    DocumentBuilder builder;
                    builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    InputSource source = new InputSource(xin);
                    Document document = builder.parse(source);

                    XPathFactory factory= XPathFactory.newInstance();

                    XPath xpath= (XPath) factory.newXPath();
                    NodeList o= (NodeList)xpath.evaluate( "/stream/properties/@*", document, XPathConstants.NODESET );

                    String result= "";
                    for ( int ii=0; ii<o.getLength(); ii++ ) {
                        result+= "\n" + o.item(ii).getNodeName() + "  =  " +  o.item(ii).getNodeValue();
                    }
                    in.close();

                    JTextArea area= new JTextArea();
                    area.setText(result);
                    area.setEditable(false);
                    final JPopupMenu copyMenu= new JPopupMenu();
                    copyMenu.add( new DefaultEditorKit.CopyAction() ).setText("Copy");
                    area.addMouseListener( new MouseAdapter() {
                        @Override
                        public void mousePressed(MouseEvent e) {
                            if ( e.isPopupTrigger() ) copyMenu.show(e.getComponent(), e.getX(), e.getY() );
                        }
                        @Override
                        public void mouseReleased(MouseEvent e) {
                            if ( e.isPopupTrigger() ) copyMenu.show(e.getComponent(), e.getX(), e.getY() );
                        }
                    });
                    JScrollPane sp= new JScrollPane( area,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
                    sp.setPreferredSize(new java.awt.Dimension( 480,480));
                    JOptionPane.showMessageDialog( this, sp );
                    

                } catch (XPathExpressionException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } catch (SAXException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } catch (ParserConfigurationException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                } finally {
                    try {
                        in.close();
                    } catch (IOException ex) {
                        Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }//GEN-LAST:event_viewDsdfButtonActionPerformed

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        setServerURL( String.valueOf( jComboBox1.getSelectedItem() ) );
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void discoveryCbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_discoveryCbActionPerformed
        getDataSetsRunnable().run();
    }//GEN-LAST:event_discoveryCbActionPerformed

    private void examplesComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_examplesComboBoxActionPerformed
        String item= (String) examplesComboBox.getSelectedItem();
        if ( !item.equals("Examples") ) {
            timeRangeTextField.setText(item);
        }
    }//GEN-LAST:event_examplesComboBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JTextArea ReaderParamsTextArea;
    public javax.swing.JLabel descriptionLabel;
    public javax.swing.JCheckBox discoveryCb;
    public javax.swing.JComboBox examplesComboBox;
    public javax.swing.JComboBox jComboBox1;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JLabel jLabel3;
    public javax.swing.JLabel jLabel4;
    public javax.swing.JLabel jLabel5;
    public javax.swing.JLabel jLabel6;
    public javax.swing.JLabel jLabel7;
    public javax.swing.JScrollPane jScrollPane1;
    public javax.swing.JScrollPane jScrollPane2;
    public javax.swing.JTree jTree1;
    public javax.swing.JTextField tcaItem;
    public javax.swing.JTextField tcaTextField;
    public javax.swing.JTextField timeRangeTextField;
    public javax.swing.JLabel validRangeLabel;
    public javax.swing.JButton viewDsdfButton;
    // End of variables declaration//GEN-END:variables


    protected String serverURL = null;
    public static final String PROP_SERVERURL = "serverURL";

    public String getServerURL() {
        return serverURL;
    }

    public void setServerURL(String serverURL) {
        String oldServerURL = this.serverURL;
        this.serverURL = serverURL;
        new Thread( getDataSetsRunnable() ).start();
        firePropertyChange(PROP_SERVERURL, oldServerURL, serverURL);
    }

    protected String dataSetId = null;
    public static final String PROP_DATASETID = "dataSetId";

    public String getDataSetId() {
        return dataSetId;
    }

    public void setDataSetId(String dataSetId) {
        String oldDataSetId = this.dataSetId;
        this.dataSetId = dataSetId;
        firePropertyChange(PROP_DATASETID, oldDataSetId, dataSetId);
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean reject(String uri) throws Exception {
        URISplit split = URISplit.parse(uri);
        if ( split.file==null || split.file.equals("file:///") ) { // use UIOWA's main one by default.
            split.file= "http://www-pw.physics.uiowa.edu/das/das2Server";
        }
        String s= split.file.toString();
        if ( s.equals("http://www-pw.physics.uiowa.edu/das/das2Server") ) {
            return false;
        }
        URL url= new URL(s+"?server=logo");
        URLConnection connect= url.openConnection();
        try {
            InputStream in= connect.getInputStream();
            if ( connect.getContentType().startsWith("image") ) {
                in.close();
                return false;
            } else {
                in.close();
                return true;
            }
        } catch ( IOException ex ) {
            return false; // we'll tell them later
        }
    }


    public boolean prepare( String uri, java.awt.Window parent, ProgressMonitor mon) {
        return true;
    }

    public void setURI(String uri) {
        URI home=null;
        try {
            home = new URI("http://www-pw.physics.uiowa.edu/das/das2Server");
        } catch (URISyntaxException ex) {
            Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }

        URISplit split= URISplit.parse(uri);
        if ( split.file==null || split.file.equals("file:///") ) {
            split.resourceUri = home;
        }
        List<URI> servers= new ArrayList();
        servers.add(home);
        try {
            servers.add(new URI("http://cassini.physics.uiowa.edu/das/das2Server"));
        } catch (URISyntaxException ex) {
            Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        if ( !split.resourceUri.equals( home ) ) {
            servers.add( split.resourceUri );
        }
        serverURL= DataSetURI.fromUri( split.resourceUri );
        Map<String,String> params= URISplit.parseParams(split.params);
        dataSetId= params.remove("dataset");
        String startTime= params.remove("start_time");
        String endTime= params.remove("end_time");
        if ( startTime!=null ) {
            try {
                DatumRange dr = DatumRangeUtil.parseTimeRange(startTime + " to " + endTime);
                timeRangeTextField.setText(dr.toString());
            } catch (ParseException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            timeRangeTextField.setText( DEFAULT_TIMERANGE );
        }
        String interval= params.remove("interval");
        if ( interval!=null ) {
            tcaTextField.setText(interval);
        }
        String item= params.remove("item");
        if ( item!=null ) {
            tcaItem.setText(item);
        }
        StringBuffer paramsStr= new StringBuffer();
        for ( Entry<String,String> e: params.entrySet() ) {
            if ( e.getKey().startsWith("arg_") ) {
                paramsStr.append(e.getValue()+"\n");
            } else {
                paramsStr.append(e.getKey()+"="+e.getValue()+"\n");
            }
        }
        ReaderParamsTextArea.setText(paramsStr.toString());

        this.jComboBox1.setModel( new DefaultComboBoxModel(servers.toArray()) );
        this.jComboBox1.setSelectedItem(split.resourceUri);

        new Thread( getDataSetsRunnable() ).start();

    }

    Runnable getDataSetsRunnable() {
        Runnable run= new Runnable() {
            public void run() {
                String ss= jComboBox1.getSelectedItem().toString();
                try {
                    DasServer server= DasServer.create( new URL( ss ) );
                    TreeModel model;
                    if ( discoveryCb.isSelected() ) {
                        model= server.getDataSetListWithDiscovery();
                    } else {
                        model= server.getDataSetList();
                    }
                    jTree1.setModel(model);
                    if ( dataSetId!=null ) selectDataSetId();
                } catch (DasException ex) {

                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);

                    javax.swing.tree.DefaultMutableTreeNode treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("Error connecting to " + ss + ", \n" + ex );
                    jTree1.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));

                } catch (MalformedURLException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    DasApplication.getDefaultApplication().getExceptionHandler().handle(ex);
                }

            }
        };
        return run;
    }

    private void selectDataSetId() {
        String[] ss= dataSetId.split("/");
        TreeNode[] oo= new TreeNode[ss.length+1];
        oo[0]= (TreeNode) jTree1.getModel().getRoot();
        for ( int i=1; i<oo.length; i++ ) {
            for ( int j=0; j<oo[i-1].getChildCount(); j++ ) {
                DefaultMutableTreeNode kid= (DefaultMutableTreeNode) oo[i-1].getChildAt(j);
                if ( kid.getUserObject().equals( ss[i-1] ) ) {
                    oo[i]= kid;
                    break;
                }
            }
            if ( oo[i]==null ) {
                return;
            }
        }
        final TreePath tp= new TreePath( oo );
        Runnable run= new Runnable() {
            public void run() {
            jTree1.setSelectionPath(tp);
            jTree1.scrollPathToVisible(tp);
            }
        };
        SwingUtilities.invokeLater(run);
        
    }

    public String getURI() {
        DatumRange timeRange=null;
        try {
            timeRange = DatumRangeUtil.parseTimeRange(timeRangeTextField.getText());
        } catch (ParseException ex) {
            Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        TreePath tp=  jTree1.getSelectionPath();
        Object[] tp0= tp.getPath();
        String dataSetId= (String) ((DefaultMutableTreeNode) tp0[1]).getUserObject();
        for ( int i=2; i<tp0.length; i++ ) dataSetId += "/"+ (String) ((DefaultMutableTreeNode) tp0[i]).getUserObject();

        LinkedHashMap<String,String> map= new LinkedHashMap();
        String readerParams= ReaderParamsTextArea.getText();
        String[] ss= readerParams.split("\n");
        int iargc=0;
        for ( int i=0; i<ss.length; i++ ) {
            String s= ss[i].trim();
            if ( s.length()==0 ) continue;
            String[] ss2= s.split("=",-2);
            if ( ss2.length==1 ) {
                map.put( "arg_"+iargc,ss2[0] );
                iargc++;
            } else {
                map.put( ss2[0], ss2[1] );
            }
        }
        String params= URISplit.formatParams(map);

        String result= "vap+das2server:"+serverURL + "?" +
                "dataset="+dataSetId  +
                "&start_time="+ timeRange.min() +
                "&end_time="+ timeRange.max();

        String tcaInterval= tcaTextField.getText().trim();
        if ( !tcaInterval.equals("") ) {
            result+= "&interval="+ tcaInterval;
        }
        if ( !tcaItem.getText().trim().equals("") ) {
            result+= "&item="+ tcaItem.getText().trim();
        }
        
        if ( params.length()>0 ) result= result + "&" + params;
        return result;
    }

    //private boolean expert;
    
    /**
     * call this before prepare.
     * @param expert
     */
    public void setExpertMode( boolean expert ) {
        //this.expert= expert;
        this.discoveryCb.setSelected(!expert);
    }
}
