/*
 * DataSourceEditorDialog.java
 *
 * Created on November 30, 2008, 12:56 PM
 */

package org.virbo.datasource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;

/**
 *
 * @author  jbf
 */
public class DataSourceEditorDialog extends javax.swing.JDialog {

    
    /** Creates new form DataSourceEditorDialog */
    public DataSourceEditorDialog( java.awt.Frame parent, Component message, boolean modal ) {
        super(parent, modal);
        initComponents();
        this.jPanel1.add(message,BorderLayout.CENTER);
        setLocationRelativeTo(parent);
        this.validate();
    }

    public DataSourceEditorDialog( java.awt.Dialog parent, Component message, boolean modal ) {
        super(parent, modal);
        initComponents();
        this.jPanel1.add(message,BorderLayout.CENTER);
        setLocationRelativeTo(parent);
        this.validate();
    }

    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";

    public boolean isCancelled() {
        return cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";

    public int getModifiers() {
        return modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setExpertMode( boolean expert ) {
        if ( overplotButton.isVisible() ) { // support setPlayButton
            overplotButton.setVisible(expert);
            plotBelowButton.setVisible(expert);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        okayButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        plotBelowButton = new javax.swing.JButton();
        overplotButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jPanel1.setLayout(new java.awt.BorderLayout());

        okayButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/go.png"))); // NOI18N
        okayButton.setText("Ok");
        okayButton.setToolTipText("Plot, replacing any previous plot.");
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        plotBelowButton.setText("Plot Below");
        plotBelowButton.setToolTipText("Plot below the current plot.");
        plotBelowButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotBelowButtonActionPerformed(evt);
            }
        });

        overplotButton.setText("Overplot");
        overplotButton.setToolTipText("Add this to the current plot as an overplot");
        overplotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overplotButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(cancelButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(overplotButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotBelowButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(okayButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 73, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(okayButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 29, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(cancelButton)
                .add(plotBelowButton)
                .add(overplotButton))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(525, Short.MAX_VALUE)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 838, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 444, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    this.cancelled= true;
    this.setVisible(false);
}//GEN-LAST:event_cancelButtonActionPerformed

private void okayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonActionPerformed
    this.cancelled= false;
    this.setModifiers(evt.getModifiers());
    this.setVisible(false);
}//GEN-LAST:event_okayButtonActionPerformed

private void plotBelowButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotBelowButtonActionPerformed
    this.cancelled= false;
    setModifiers( KeyEvent.CTRL_MASK );
    this.setVisible(false);
}//GEN-LAST:event_plotBelowButtonActionPerformed

private void overplotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overplotButtonActionPerformed
    this.cancelled= false;
    setModifiers( KeyEvent.SHIFT_MASK );
    this.setVisible(false);
}//GEN-LAST:event_overplotButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton okayButton;
    private javax.swing.JButton overplotButton;
    private javax.swing.JButton plotBelowButton;
    // End of variables declaration//GEN-END:variables

    /**
     * provide way to hide the play button.
     */
    void setPlayButton(boolean b) {
        if ( b ) {
            okayButton.setIcon(  new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/go.png") ) );
        } else {
            okayButton.setIcon(null);
        }
        plotBelowButton.setVisible(b);
        overplotButton.setVisible(b);
    }

}
