/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * TimeRangePanel.java
 *
 * Created on Jun 4, 2011, 9:33:57 AM
 */

package org.virbo.datasource;

import java.awt.CardLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.DefaultEditorKit;
import org.das2.DasApplication;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.UnitsUtil;

/**
 *  
 * @author jbf
 */
public class TimeRangeEditor extends javax.swing.JPanel {

    /** Creates new form TimeRangePanel */
    public TimeRangeEditor() {
        initComponents();
        addMousePopupListener();
    }

    DatumRange range= DatumRangeUtil.parseTimeRangeValid( "2010-01-01" );

    /**
     * use DOY instead of Y-M-D
     */
    boolean useDoy=false;

    public boolean isUseDoy() {
        return useDoy;
    }

    public void setUseDoy(boolean useDoy) {
        boolean old= this.useDoy;
        this.useDoy = useDoy;
        DatumRangeUtil.useDoy= useDoy;
        firePropertyChange("useDoy",old,useDoy);
    }

    public DatumRange getRange() {
        return range;
    }

    public void setRange( DatumRange value ) {
        DatumRange oldValue= this.range;
        this.range= value;
        if (oldValue != value && oldValue != null && !oldValue.equals(value)) {
            super.firePropertyChange("range", oldValue, value);
        }
        this.timeRangeTextField.setText( value.toString() );
    }

    private void parseRange() {
        DatumRange dr;
        DatumRange value= this.range;

        String text= timeRangeTextField.getText();
        try {
            String rangeString= text;
            dr= DatumRangeUtil.parseTimeRange(rangeString);
            setRange(dr);
        } catch ( ParseException e ) {
            timeRangeTextField.setText( range.toString() );
            if ( UnitsUtil.isTimeLocation(value.getUnits()) ) { // go ahead and handle non-times.
                showErrorUsage( text, "unable to parse time range" );
            } else {
                //showErrorUsage( text, "unable to parse range" );
            }
        } catch ( IllegalArgumentException e ) {
            if ( value!=null ) {
                setRange( value ); // cause reformat of old Datum
                if ( e.getMessage().contains("min > max") ) {
                    showErrorUsage( text, "min cannot be greater than max" );
                } else {
                    showErrorUsage( text, e.getMessage() );
                }
            }
        }

        return;
    }

    /**
     * prevent displaying same message so many times...
     */
    private String lastErrorText= null;
    private long lastErrorTime= 0;

    private void showErrorUsage( String text, String why ) {
        if ( !DasApplication.getDefaultApplication().isHeadless() ) {
            if ( text!=null && text.equals(lastErrorText)
                    && (System.currentTimeMillis()-lastErrorTime)<5000 ) {
                return;
            }
            if ( why!=null ) {
                JOptionPane.showMessageDialog( this, "<html>Unable to accept \""+text+"\"<br>"+why+"<html>" );
            } else {
                JOptionPane.showMessageDialog( this, "<html>Unable to accept \""+text+"\"</html>" );
            }
            lastErrorText= text;
            lastErrorTime= System.currentTimeMillis();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        prevButton = new javax.swing.JButton();
        nextButton = new javax.swing.JButton();
        timeRangeTextField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();

        setPreferredSize(new java.awt.Dimension(384, 39));

        prevButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/prevPrev.png"))); // NOI18N
        prevButton.setToolTipText("Scan to the previous interval");
        prevButton.setMaximumSize(new java.awt.Dimension(34, 20));
        prevButton.setMinimumSize(new java.awt.Dimension(34, 20));
        prevButton.setPreferredSize(new java.awt.Dimension(34, 20));
        prevButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                prevButtonActionPerformed(evt);
            }
        });

        nextButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/nextNext.png"))); // NOI18N
        nextButton.setToolTipText("Scan to the next interval");
        nextButton.setMaximumSize(new java.awt.Dimension(34, 24));
        nextButton.setMinimumSize(new java.awt.Dimension(34, 24));
        nextButton.setPreferredSize(new java.awt.Dimension(34, 24));
        nextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextButtonActionPerformed(evt);
            }
        });

        timeRangeTextField.setText("2010-01-01");
        timeRangeTextField.setToolTipText("<html>Adjust Application Time Range<br>\nFor example:<br>\n2010:  the year 2010.<br>\n2010-01: the month 2010-Jan<br>\n2010-001 or 2010-01-01: Jan 1, 2010<br>\n2010-01-01 08:00 to 09:00<br>\n</html>");
        timeRangeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                timeRangeTextFieldActionPerformed(evt);
            }
        });
        timeRangeTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                timeRangeTextFieldFocusLost(evt);
            }
        });

        browseButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/fileMag.png"))); // NOI18N
        browseButton.setToolTipText("Edit data source");
        browseButton.setEnabled(false);
        browseButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        browseButton.setMaximumSize(new java.awt.Dimension(20, 20));
        browseButton.setMinimumSize(new java.awt.Dimension(20, 20));
        browseButton.setPreferredSize(new java.awt.Dimension(20, 20));
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(timeRangeTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 256, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(prevButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 40, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(nextButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 34, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(browseButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        layout.linkSize(new java.awt.Component[] {nextButton, prevButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE, false)
                        .add(browseButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 27, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(nextButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(prevButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timeRangeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 27, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {browseButton, nextButton, prevButton, timeRangeTextField}, org.jdesktop.layout.GroupLayout.VERTICAL);

    }// </editor-fold>//GEN-END:initComponents

    private void nextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextButtonActionPerformed
        setRange( range.next() );
    }//GEN-LAST:event_nextButtonActionPerformed

    private void prevButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_prevButtonActionPerformed
        setRange( range.previous() );
    }//GEN-LAST:event_prevButtonActionPerformed

    private void timeRangeTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_timeRangeTextFieldFocusLost
        parseRange();
    }//GEN-LAST:event_timeRangeTextFieldFocusLost

    private void timeRangeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_timeRangeTextFieldActionPerformed
        parseRange();
    }//GEN-LAST:event_timeRangeTextFieldActionPerformed

    DataSetSelector peer;

    public void setDataSetSelectorPeer( DataSetSelector peer ) {
        this.peer= peer;
        browseButton.setEnabled(true);
    }

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        if ( peer!=null ) {
            String surl = ((String) peer.getEditor().getText()).trim();//TODO:check

            boolean wasRejected= false;
            DataSourceEditorPanel edit = null;
            try {
                edit = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.getURIValid(surl));
                if ( edit!=null && edit.reject(surl) ) {
                    edit= null;
                    wasRejected= true;
                }
            } catch (URISyntaxException ex) {
                Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                edit= null;
            } catch ( Exception ex ) {
                Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                edit= null;
            }
            if ( edit==null ) {
                JOptionPane.showMessageDialog( prevButton, "this type has no editor", "no editor", JOptionPane.OK_OPTION );
            } else {
                peer.browseSourceType();
            }
        }
    }//GEN-LAST:event_browseButtonActionPerformed

    public static void main( String[] args ) {
        TimeRangeEditor p= new TimeRangeEditor();
        p.addPropertyChangeListener( "range", new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getOldValue()+" -> "+ evt.getNewValue() );
            }

        } );
        JFrame f= new JFrame();
        f.setContentPane( p );
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JButton nextButton;
    private javax.swing.JButton prevButton;
    private javax.swing.JTextField timeRangeTextField;
    // End of variables declaration//GEN-END:variables

    public PropertyChangeListener getUriFocusListener() {
        return new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                browseButton.setToolTipText( "<html>Edit data source<br>"+evt.getNewValue().toString()+"</html>" );
            }
        };
    }

    private String alternatePeer;
    private String alternatePeerCard;

    public void setAlternatePeer(String label, String card ) {
        this.alternatePeer= label;
        this.alternatePeerCard= card;
    }

    
    private void addMousePopupListener() {
        timeRangeTextField.addMouseListener( new MouseAdapter() {

            @Override
            public void mouseClicked(MouseEvent e) {
                if ( e.isPopupTrigger() ) showPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if ( e.isPopupTrigger() ) showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if ( e.isPopupTrigger() ) showPopup(e);
            }

        });
    }
    private void showPopup( MouseEvent e ) {
        getPopupMenu().show( this, e.getX(), e.getY() );
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu result= new JPopupMenu();
        JMenuItem cutItem = result.add(new DefaultEditorKit.CutAction());
        cutItem.setText("Cut");
        JMenuItem copyItem = result.add(new DefaultEditorKit.CopyAction());
        copyItem.setText("Copy");
        JMenuItem pasteItem = result.add(new DefaultEditorKit.PasteAction());
        pasteItem.setText("Paste");

        if ( this.alternatePeerCard!=null ) {
            result.add( new JSeparator() );
            result.add( new AbstractAction( alternatePeer ) {
                public void actionPerformed(ActionEvent ev) {
                    Container trp= TimeRangeEditor.this.getParent();
                    ((CardLayout)trp.getLayout()).show( trp, alternatePeerCard );
                }
            } );
        }


        return result;

    }


}
