/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AsciiTableDataSourceFormatEditorPanel.java
 *
 * Created on Mar 10, 2011, 3:20:04 PM
 */

package org.virbo.ascii;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.virbo.datasource.DataSourceFormatEditorPanel;
import org.virbo.datasource.URISplit;

/**
 *
 * @author jbf
 */
public class AsciiTableDataSourceFormatEditorPanel extends javax.swing.JPanel implements DataSourceFormatEditorPanel {

    String file;

    /** Creates new form AsciiTableDataSourceFormatEditorPanel */
    public AsciiTableDataSourceFormatEditorPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        useFormatSpecCB = new javax.swing.JCheckBox();
        richHeadersCB = new javax.swing.JCheckBox();
        explicitFormatSpecPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        numberFormatSpecifierTF = new javax.swing.JTextField();
        timesFormatTF = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();

        useFormatSpecCB.setText("Explicit Format Specifiers");
        useFormatSpecCB.setToolTipText("Specify the format to for numbers and times.");

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), useFormatSpecCB, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        richHeadersCB.setText("Rich Headers");
        richHeadersCB.setToolTipText("<html>Add additional information about the dataset, <br>\nsuch as titles and valid ranges, in a comment block <br>\nat the top of the ascii output.</html>");
        richHeadersCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                richHeadersCBActionPerformed(evt);
            }
        });

        jLabel1.setText("Numbers:");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), jLabel1, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        numberFormatSpecifierTF.setText("%5.2f");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), numberFormatSpecifierTF, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        timesFormatTF.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Day", "Minute", "Second", "Millisecond", "Microsecond", " " }));
        timesFormatTF.setSelectedIndex(3);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), timesFormatTF, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        jLabel2.setText("Time Resolution:");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), jLabel2, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        org.jdesktop.layout.GroupLayout explicitFormatSpecPanelLayout = new org.jdesktop.layout.GroupLayout(explicitFormatSpecPanel);
        explicitFormatSpecPanel.setLayout(explicitFormatSpecPanelLayout);
        explicitFormatSpecPanelLayout.setHorizontalGroup(
            explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(explicitFormatSpecPanelLayout.createSequentialGroup()
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(jLabel2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(numberFormatSpecifierTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 80, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timesFormatTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        explicitFormatSpecPanelLayout.setVerticalGroup(
            explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(explicitFormatSpecPanelLayout.createSequentialGroup()
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(numberFormatSpecifierTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(timesFormatTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(40, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(useFormatSpecCB)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(explicitFormatSpecPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(richHeadersCB))
                .addContainerGap(112, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(richHeadersCB)
                .add(8, 8, 8)
                .add(useFormatSpecCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

    private void richHeadersCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_richHeadersCBActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_richHeadersCBActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel explicitFormatSpecPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField numberFormatSpecifierTF;
    private javax.swing.JCheckBox richHeadersCB;
    private javax.swing.JComboBox timesFormatTF;
    private javax.swing.JCheckBox useFormatSpecCB;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    public JPanel getPanel() {
        return this;
    }

    public void setURI(String uri) {
        URISplit split= URISplit.parse(uri);
        file= split.file;
        Map<String,String> args= URISplit.parseParams(split.params);
        String s;
        useFormatSpecCB.setSelected(false);
        s= args.get("format");
        if ( s!=null ) {
            numberFormatSpecifierTF.setText( args.get("format") );
            useFormatSpecCB.setSelected(true);
        }
        s= args.get("tformat");
        if ( s!=null ) {
            timesFormatTF.setSelectedItem(s);
            useFormatSpecCB.setSelected(true);
        }
        s= args.get("header");
        if ( "rich".equals(s) ) {
            richHeadersCB.setSelected(true);
        }
    }

    public String getURI() {
        String result= file;
        Map<String,String> args= new HashMap();

        if ( useFormatSpecCB.isSelected() ) {
            try {
                args.put("format", URLEncoder.encode(numberFormatSpecifierTF.getText(), "UTF-8"));
            } catch (UnsupportedEncodingException ex) {
                Logger.getLogger(AsciiTableDataSourceFormatEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            String ts= String.valueOf( timesFormatTF.getSelectedItem() );
//            if ( includeZ.isSelected() ) {
            args.put( "tformat", ts );
//            } else {
//                args.put( "tformat", ts + "NoZ" );
//            }
        }

        if ( richHeadersCB.isSelected() ) {
            args.put( "header", "rich" );
        }

        String params= URISplit.formatParams(args);
        if ( result==null ) result= "file:///";
        URISplit ss= URISplit.parse(result);

        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );

    }


}
