/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CreatePngWalkDialog.java
 *
 * Created on Jun 30, 2010, 9:09:46 AM
 */

package org.autoplot.pngwalk;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

/**
 *
 * @author jbf
 */
public class CreatePngWalkDialog extends javax.swing.JPanel {

    /** Creates new form CreatePngWalkDialog */
    public CreatePngWalkDialog() {
        initComponents();
        String home= java.lang.System.getProperty( "user.home" ) + java.lang.System.getProperty( "file.separator" );
        home= home.replaceAll("\\\\","/");
        outputFolderTf.setText( home + "pngwalk/" );
        setDefaults();
        checkExists();
    }

    private void setDefaults() {
        Preferences prefs= Preferences.userNodeForPackage( CreatePngWalkDialog.class );

        String file= prefs.get( "filenameRoot", flnRootTf.getText() );
        flnRootTf.setText(file);
        String home= prefs.get( "outputFolder", outputFolderTf.getText() );
        outputFolderTf.setText(home);
        String timeFormat= prefs.get("timeFormat", timeFormatTf.getText() );
        timeFormatTf.setText(timeFormat);
        String timeRange= prefs.get("timeRange", timeRangeTf.getText() );
        timeRangeTf.setText( timeRange );
        boolean thumbs= prefs.getBoolean( "createThumbs", createThumbsCb.isSelected() );
        createThumbsCb.setSelected(thumbs);
    }

    public void writeDefaults() {
        Preferences prefs= Preferences.userNodeForPackage( CreatePngWalkDialog.class );
        prefs.put( "filenameRoot", flnRootTf.getText() );
        prefs.put( "outputFolder", outputFolderTf.getText() );
        prefs.put("timeFormat", timeFormatTf.getText() );
        prefs.put("timeRange", timeRangeTf.getText() );
        prefs.putBoolean( "createThumbs", createThumbsCb.isSelected() );
        try {
            prefs.flush();
        } catch (BackingStoreException ex) {
            Logger.getLogger(CreatePngWalkDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void checkExists() {
        String sf= outputFolderTf.getText();
        File f= new File( sf );
        overwriteCB.setEnabled(f.exists());
        if ( !f.exists() ) {
            overwriteCB.setSelected(false);
        }
    }

    public JTextField getFlnRootTf() {
        return flnRootTf;
    }

    public JTextField getOutputFolderTf() {
        return outputFolderTf;
    }

    public JTextField getTimeFormatTf() {
        return timeFormatTf;
    }

    public JTextField getTimeRangeTf() {
        return timeRangeTf;
    }

    public JCheckBox getCreateThumbsCb() {
        return createThumbsCb;
    }

    public JCheckBox getOverwriteCb() {
        return overwriteCB;
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        flnRootTf = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        outputFolderTf = new javax.swing.JTextField();
        pickFolderButton = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        timeFormatTf = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        timeRangeTf = new javax.swing.JTextField();
        createThumbsCb = new javax.swing.JCheckBox();
        overwriteCB = new javax.swing.JCheckBox();

        jLabel1.setText("Filename Root:");

        flnRootTf.setText("product");
        flnRootTf.setToolTipText("Stem used to ensure unique filenames");

        jLabel2.setText("Output Folder:");

        outputFolderTf.setText("/folder/");
        outputFolderTf.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                outputFolderTfKeyReleased(evt);
            }
            public void keyTyped(java.awt.event.KeyEvent evt) {
                outputFolderTfKeyTyped(evt);
            }
        });

        pickFolderButton.setText("Pick");
        pickFolderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pickFolderButtonActionPerformed(evt);
            }
        });

        jLabel3.setText("Time Format:");

        timeFormatTf.setText("$Y$m$d");
        timeFormatTf.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                timeFormatTfActionPerformed(evt);
            }
        });

        jLabel4.setText("Time Range:");

        timeRangeTf.setText("2010");

        createThumbsCb.setSelected(true);
        createThumbsCb.setText("Create Thumbs");

        overwriteCB.setText("Overwrite");
        overwriteCB.setToolTipText("overwrite existing pngwalk");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(flnRootTf, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE))
                            .add(jLabel1)
                            .add(jLabel2)
                            .add(jLabel3)
                            .add(layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(overwriteCB)
                                    .add(layout.createSequentialGroup()
                                        .add(outputFolderTf, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE)
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(pickFolderButton))))))
                    .add(layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(timeFormatTf, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel4))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(createThumbsCb))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(timeRangeTf, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(flnRootTf, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(outputFolderTf, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(pickFolderButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(overwriteCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(timeFormatTf, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel4)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(timeRangeTf, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(12, 12, 12)
                .add(createThumbsCb)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void pickFolderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pickFolderButtonActionPerformed
        JFileChooser chooser= new JFileChooser( getOutputFolderTf().getText() );
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int r= chooser.showSaveDialog(this);
        if ( r==JFileChooser.APPROVE_OPTION ) {
            outputFolderTf.setText( chooser.getSelectedFile().toString() );
        }
    }//GEN-LAST:event_pickFolderButtonActionPerformed

    private void outputFolderTfKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_outputFolderTfKeyTyped
        checkExists();
    }//GEN-LAST:event_outputFolderTfKeyTyped

    private void timeFormatTfActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_timeFormatTfActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_timeFormatTfActionPerformed

    private void outputFolderTfKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_outputFolderTfKeyReleased
        checkExists();
    }//GEN-LAST:event_outputFolderTfKeyReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox createThumbsCb;
    private javax.swing.JTextField flnRootTf;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField outputFolderTf;
    private javax.swing.JCheckBox overwriteCB;
    private javax.swing.JButton pickFolderButton;
    private javax.swing.JTextField timeFormatTf;
    private javax.swing.JTextField timeRangeTf;
    // End of variables declaration//GEN-END:variables

}
