/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AddPlotElementDialog.java
 *
 * Created on Apr 6, 2009, 10:54:02 AM
 */

package org.virbo.autoplot;

import java.awt.event.KeyEvent;

/**
 *
 * @author jbf
 */
public class AddPlotElementDialog extends javax.swing.JDialog {

    /** Creates new form AddPlotElementDialog */
    public AddPlotElementDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
        secondaryDataSetSelector.setVisible(secondaryCheckBox.isSelected());
        tertiaryCheckBox.setVisible(secondaryCheckBox.isSelected());
        tertiaryDataSetSelector.setVisible(secondaryCheckBox.isSelected()&&tertiaryCheckBox.isSelected());
        primaryDataSetSelector.setPlotItButtonVisible(false);
        secondaryDataSetSelector.setPlotItButtonVisible(false);
        tertiaryDataSetSelector.setPlotItButtonVisible(false);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        primaryDataSetSelector = new org.virbo.datasource.DataSetSelector();
        secondaryCheckBox = new javax.swing.JCheckBox();
        secondaryDataSetSelector = new org.virbo.datasource.DataSetSelector();
        tertiaryCheckBox = new javax.swing.JCheckBox();
        tertiaryDataSetSelector = new org.virbo.datasource.DataSetSelector();
        overplotButton = new javax.swing.JButton();
        plotBelowButton = new javax.swing.JButton();
        plotButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        secondaryCheckBox.setText("Plot Against (X):");
        secondaryCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secondaryCheckBoxActionPerformed(evt);
            }
        });

        tertiaryCheckBox.setText("And Against (Y):");
        tertiaryCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tertiaryCheckBoxActionPerformed(evt);
            }
        });

        overplotButton.setText("Overplot");
        overplotButton.setToolTipText("Add this to the current plot as an overplot");
        overplotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overplotButtonActionPerformed(evt);
            }
        });

        plotBelowButton.setText("Plot Below");
        plotBelowButton.setToolTipText("Plot below the current plot, possibly inserting a plot.");
        plotBelowButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotBelowButtonActionPerformed(evt);
            }
        });

        plotButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/go.png"))); // NOI18N
        plotButton.setText("Plot");
        plotButton.setToolTipText("Replace the current plot with this");
        plotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("Plot the Data Set URI:");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(cancelButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(overplotButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(plotBelowButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(plotButton))
                    .add(primaryDataSetSelector, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 678, Short.MAX_VALUE)
                    .add(secondaryCheckBox)
                    .add(secondaryDataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .add(tertiaryCheckBox)
                    .add(tertiaryDataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 503, Short.MAX_VALUE)
                        .add(175, 175, 175)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(primaryDataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(secondaryCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(secondaryDataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(tertiaryCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(tertiaryDataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 70, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(plotButton)
                    .add(plotBelowButton)
                    .add(overplotButton)
                    .add(cancelButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void secondaryCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secondaryCheckBoxActionPerformed
        if ( secondaryCheckBox.isSelected() ) {
            secondaryDataSetSelector.setValue(primaryDataSetSelector.getValue());
        }
        secondaryDataSetSelector.setVisible(secondaryCheckBox.isSelected());
        tertiaryCheckBox.setVisible(secondaryCheckBox.isSelected());
        tertiaryDataSetSelector.setVisible(secondaryCheckBox.isSelected()&&tertiaryCheckBox.isSelected());
}//GEN-LAST:event_secondaryCheckBoxActionPerformed

    private void overplotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overplotButtonActionPerformed
        setModifiers( KeyEvent.SHIFT_MASK );
        cancelled= false;
        setVisible(false);
}//GEN-LAST:event_overplotButtonActionPerformed

    private void plotBelowButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotBelowButtonActionPerformed
        cancelled= false;
        setModifiers( KeyEvent.CTRL_MASK );
        setVisible(false);
}//GEN-LAST:event_plotBelowButtonActionPerformed

    private void plotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotButtonActionPerformed
        cancelled= false;
        setModifiers( evt.getModifiers() );
        setVisible(false);
}//GEN-LAST:event_plotButtonActionPerformed

    private void tertiaryCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tertiaryCheckBoxActionPerformed
        if ( tertiaryCheckBox.isSelected() ) {
            tertiaryDataSetSelector.setValue(primaryDataSetSelector.getValue());
        }
        tertiaryDataSetSelector.setVisible(tertiaryCheckBox.isSelected());
    }//GEN-LAST:event_tertiaryCheckBoxActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false);
}//GEN-LAST:event_cancelButtonActionPerformed

    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";

    public int getModifiers() {
        return modifiers;
    }

    public void setModifiers(int modifiers) {
        int oldModifiers = this.modifiers;
        this.modifiers = modifiers;
        firePropertyChange(PROP_MODIFIERS, oldModifiers, modifiers);
    }

    /**
     * return the number of depend datasets added, 0, or -1 if no dataset
     * should be plotted.
     * @return
     */
    public int getDepCount() {
        if ( tertiaryCheckBox.isSelected() ) {
            return 2;
        } else if (  secondaryCheckBox.isSelected() ) {
            return 1;
        } else if ( true ) {
            return 0;
        } else {
            return -1;
        }
    }

    public void setDepCount(int i) {
        //primaryCheckBox.setSelected( i>-1 );
        primaryDataSetSelector.setVisible(i>-1);
        secondaryCheckBox.setVisible(i>-1);
        secondaryCheckBox.setSelected( i>0 );
        secondaryDataSetSelector.setVisible(i>0);
        tertiaryCheckBox.setVisible(i>0);
        tertiaryCheckBox.setSelected( i>1 );
        tertiaryDataSetSelector.setVisible(i>1);
    }

    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";

    public boolean isCancelled() {
        return cancelled;
    }

    /**
     * @return the primaryDataSetSelector
     */
    public org.virbo.datasource.DataSetSelector getPrimaryDataSetSelector() {
        return primaryDataSetSelector;
    }

    /**
     * @return the secondaryDataSetSelector
     */
    public org.virbo.datasource.DataSetSelector getSecondaryDataSetSelector() {
        return secondaryDataSetSelector;
    }

    /**
     * @return the tertiaryDataSetSelector
     */
    public org.virbo.datasource.DataSetSelector getTertiaryDataSetSelector() {
        return tertiaryDataSetSelector;
    }



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton overplotButton;
    private javax.swing.JButton plotBelowButton;
    private javax.swing.JButton plotButton;
    private org.virbo.datasource.DataSetSelector primaryDataSetSelector;
    private javax.swing.JCheckBox secondaryCheckBox;
    private org.virbo.datasource.DataSetSelector secondaryDataSetSelector;
    private javax.swing.JCheckBox tertiaryCheckBox;
    private org.virbo.datasource.DataSetSelector tertiaryDataSetSelector;
    // End of variables declaration//GEN-END:variables

}
