/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AggregateUrisDialog.java
 *
 * Created on Nov 4, 2010, 1:02:38 PM
 */

package org.virbo.autoplot;

import java.awt.Font;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomOps;
import org.virbo.datasource.DataSetSelector;

/**
 *
 * @author jbf
 */
public class AggregateUrisDialog2 extends javax.swing.JPanel {

    private final Application dom;
    private final DataSetSelector dataSetSelector;

    /** Creates new form AggregateUrisDialog */
    public AggregateUrisDialog2( Application dom, DataSetSelector sel ) {
        initComponents();
        this.dom= dom;
        this.dataSetSelector= sel;

        previewDataSetSelector.setHidePlayButton(true);
        String s = dataSetSelector.getValue();
        String agg = org.virbo.datasource.DataSourceUtil.makeAggregation(s);
        if (agg != null) {
            previewDataSetSelector.setValue(agg);
        } else {
            this.jLabel5.setText( this.jLabel5.getText()+"  (Unable to create aggregation spec, couldn't find yyyymmdd.)");
            previewDataSetSelector.setValue(s);
        }
        Font f= previewDataSetSelector.getEditor().getFont().deriveFont(8.f);
        previewDataSetSelector.getEditor().setFont(f);

        Application dom2= (Application)dom.copy();
        DomOps.aggregateAll(dom2);
        allUrisTA.setText("");
        for ( DataSourceFilter dsf: dom2.getDataSourceFilters() ) {
            if ( !dsf.getUri().startsWith("vap+internal:") ) {
                allUrisTA.insert( dsf.getUri() + "\n", allUrisTA.getCaretPosition() );
            }
        }
        allUrisTA.setEditable(false);

    }

    public JRadioButton getAllUrisB() {
        return allUrisB;
    }

    public JRadioButton getFocusUriB() {
        return focusUriB;
    }

    public void doAction() {
        if ( allUrisB.isSelected() ) {
            Application dom2= (Application)dom.copy();
            DomOps.aggregateAll(dom2);
            dom.syncTo(dom2);
            DataSourceFilter[] dsfs= dom.getDataSourceFilters();
            for ( DataSourceFilter dsf: dsfs ) {
                dsf.getController().update();
            }
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        } else if ( focusUriB.isSelected() ) {
            String s = previewDataSetSelector.getEditor().getText();
            dataSetSelector.setValue(s);
            dataSetSelector.maybePlot(false);
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        previewDataSetSelector = new org.virbo.datasource.DataSetSelector();
        jScrollPane1 = new javax.swing.JScrollPane();
        allUrisTA = new javax.swing.JTextArea();
        focusUriB = new javax.swing.JRadioButton();
        allUrisB = new javax.swing.JRadioButton();

        jLabel4.setText("<html>Autoplot has two ways of turning URIs of single files into aggregations that will combine data when the first dimension is time.  An aggregation URI is one with wildcards (like $Y for year) that allows Autoplot to fetch multiple files to cover a time range.</html> ");
        jLabel4.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        jLabel5.setText("<html>Autoplot has attempted to make an aggregated URI from the focus URI.  Pressing okay will accept the new URI:</html>");
        jLabel5.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        jLabel6.setText("<html>Autoplot has attempted to form aggregations for all the URIs on the canvas.  Pressing okay will accept these changes.  Here you can review the replacement URIs:</html>");
        jLabel6.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        allUrisTA.setColumns(20);
        allUrisTA.setFont(allUrisTA.getFont().deriveFont((float)8));
        allUrisTA.setRows(5);
        allUrisTA.setText("vap+dat:http://autoplot.org/data/autoplot.dat\n");
        jScrollPane1.setViewportView(allUrisTA);

        buttonGroup1.add(focusUriB);
        focusUriB.setSelected(true);
        focusUriB.setText("Focus URI");

        buttonGroup1.add(allUrisB);
        allUrisB.setText("All URIs");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(previewDataSetSelector, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 718, Short.MAX_VALUE))
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(focusUriB)
                        .add(70, 70, 70)
                        .add(jLabel5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 574, Short.MAX_VALUE))
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 718, Short.MAX_VALUE))
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(allUrisB)
                        .add(84, 84, 84)
                        .add(jLabel6, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 575, Short.MAX_VALUE)))
                .addContainerGap())
            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jPanel1Layout.createSequentialGroup()
                    .addContainerGap()
                    .add(jLabel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 730, Short.MAX_VALUE)
                    .addContainerGap()))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(98, 98, 98)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(focusUriB))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(previewDataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(allUrisB))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(40, Short.MAX_VALUE))
            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jPanel1Layout.createSequentialGroup()
                    .addContainerGap()
                    .add(jLabel4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(258, Short.MAX_VALUE)))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton allUrisB;
    private javax.swing.JTextArea allUrisTA;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton focusUriB;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private org.virbo.datasource.DataSetSelector previewDataSetSelector;
    // End of variables declaration//GEN-END:variables

}
