/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * RecentUrisDialog.java
 *
 * Created on Apr 5, 2011, 1:51:38 PM
 */

package org.virbo.autoplot;

import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * Present GUI showing history of plotted URIs with buttons for
 * ok, plotting below, as an overplot, or editing.  The getModifiers()
 * method is called to see which action was pressed:
 *   0                    replace plot
 *   KeyEvent.CTRL_MASK   plot below
 *   KeyEvent.SHIFT_MASK  overplot
 *   KeyEvent.ALT_MASK    edit this URI.
 * @author jbf
 */
public class RecentUrisDialog extends javax.swing.JDialog {

    /** Creates new form RecentUrisDialog */
    public RecentUrisDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

        recentUrisGUI1.getTree().addMouseListener( new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                Object o=null;
                o= recentUrisGUI1.getTree().getSelectionPath();
                if ( o==null ) return;
                o= recentUrisGUI1.getTree().getSelectionPath().getLastPathComponent();
                if ( !( o instanceof String[] ) ) {
                    return;
                }
                if ( e.getClickCount()==2 ) {
                    cancelled= false;
                    RecentUrisDialog.this.setModifiers(e.getModifiers());
                    setVisible(false);
                }
            }
        } );
    }

    public void setFilter( String filter ) {
        recentUrisGUI1.setFilter( filter );
    }

    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";

    public boolean isCancelled() {
        return cancelled;
    }

    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";

    public int getModifiers() {
        return modifiers;
    }

    public void setModifiers(int modifiers) {
        int oldModifiers = this.modifiers;
        this.modifiers = modifiers;
        firePropertyChange(PROP_MODIFIERS, oldModifiers, modifiers);
    }

    public String getSelectedURI() {
        return recentUrisGUI1.getSelectedURI();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        filterTextField = new javax.swing.JTextField();
        updateButton = new javax.swing.JButton();
        recentUrisGUI1 = new org.virbo.autoplot.RecentUrisGUI();
        cancelButton = new javax.swing.JButton();
        overplotButton = new javax.swing.JButton();
        plotBelowButton = new javax.swing.JButton();
        plotButton = new javax.swing.JButton();
        editUriButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Recent History");

        jLabel1.setText("Filter:");
        jLabel1.setToolTipText("Filter URIs with free text, as in 'vap+cdf:'");

        filterTextField.setToolTipText("Filter URIs with free text, as in 'vap+cdf:'");
        filterTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterTextFieldActionPerformed(evt);
            }
        });

        updateButton.setText("Update");
        updateButton.setToolTipText("Apply filter to list of URIs");
        updateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        overplotButton.setText("Overplot");
        overplotButton.setToolTipText("Add this to the current plot as an overplot");
        overplotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overplotButtonActionPerformed(evt);
            }
        });

        plotBelowButton.setText("Plot Below");
        plotBelowButton.setToolTipText("Plot below the current plot, possibly inserting a plot.");
        plotBelowButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotBelowButtonActionPerformed(evt);
            }
        });

        plotButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/go.png"))); // NOI18N
        plotButton.setText("Plot");
        plotButton.setToolTipText("Replace the current plot with this");
        plotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotButtonActionPerformed(evt);
            }
        });

        editUriButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/autoplot/fileMag.png"))); // NOI18N
        editUriButton.setText("Edit");
        editUriButton.setToolTipText("Inspect this resource.  If an editor panel is available, this will enter the editor panel before plotting.  Otherwise the\nURI is copied to the address bar for editing with completions.");
        editUriButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editUriButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(322, Short.MAX_VALUE)
                .add(cancelButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(overplotButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(editUriButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 70, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotBelowButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 65, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(filterTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 191, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(updateButton)
                .addContainerGap(427, Short.MAX_VALUE))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, recentUrisGUI1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 781, Short.MAX_VALUE)
        );

        layout.linkSize(new java.awt.Component[] {editUriButton, plotButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 25, Short.MAX_VALUE)
                    .add(filterTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(updateButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(recentUrisGUI1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 388, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(plotButton)
                    .add(plotBelowButton)
                    .add(cancelButton)
                    .add(overplotButton)
                    .add(editUriButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void updateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_updateButtonActionPerformed
        setFilter( filterTextField.getText() );
}//GEN-LAST:event_updateButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false);
}//GEN-LAST:event_cancelButtonActionPerformed

    private void overplotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overplotButtonActionPerformed
        setModifiers( KeyEvent.SHIFT_MASK );
        cancelled= false;
        setVisible(false);
}//GEN-LAST:event_overplotButtonActionPerformed

    private void plotBelowButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotBelowButtonActionPerformed
        cancelled= false;
        setModifiers( KeyEvent.CTRL_MASK );
        setVisible(false);
}//GEN-LAST:event_plotBelowButtonActionPerformed

    private void plotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotButtonActionPerformed
        cancelled= false;
        setModifiers( evt.getModifiers() );
        setVisible(false);
}//GEN-LAST:event_plotButtonActionPerformed

    private void filterTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterTextFieldActionPerformed
        setFilter( filterTextField.getText() );
    }//GEN-LAST:event_filterTextFieldActionPerformed

    private void editUriButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editUriButtonActionPerformed
        cancelled= false;
        setModifiers( KeyEvent.ALT_MASK );
        setVisible(false);
    }//GEN-LAST:event_editUriButtonActionPerformed

    public void setExpertMode( boolean expert ) {
        editUriButton.setVisible(expert);
        overplotButton.setVisible(expert);
        plotBelowButton.setVisible(expert);
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                RecentUrisDialog dialog = new RecentUrisDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton editUriButton;
    private javax.swing.JTextField filterTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton overplotButton;
    private javax.swing.JButton plotBelowButton;
    private javax.swing.JButton plotButton;
    private org.virbo.autoplot.RecentUrisGUI recentUrisGUI1;
    private javax.swing.JButton updateButton;
    // End of variables declaration//GEN-END:variables

}
