/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * RunScriptPanel.java
 *
 * Created on Jun 21, 2011, 5:22:53 PM
 */

package org.virbo.autoplot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import org.das2.util.monitor.ProgressMonitor;
import org.python.util.InteractiveInterpreter;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.jythonsupport.ui.EditorTextPane;

/**
 *
 * @author jbf
 */
public class RunScriptPanel extends javax.swing.JPanel {

    org.virbo.jythonsupport.ui.EditorTextPane textArea;

    /** Creates new form RunScriptPanel */
    public RunScriptPanel() {
        initComponents();
        textArea = new org.virbo.jythonsupport.ui.EditorTextPane();
        scriptPanel.add( textArea );
        textArea.setEditable(false);
    }

    public EditorTextPane getTextArea() {
        return textArea;
    }

    public static void runScript( ApplicationModel model, File ff, ProgressMonitor mon ) {
        try {
            InputStream in= new FileInputStream(ff);
            StringBuilder buf= new StringBuilder();
            BufferedReader read= new BufferedReader( new InputStreamReader(in) );
            String line= read.readLine();
            while ( line!=null ) {
                buf.append(line).append("\n");
                line= read.readLine();
            }
            read.close();
            if ( buf.length()>0  ) {
                InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false);
                interp.set("dom", model.getDocumentModel());
                interp.set("monitor", mon);
                interp.exec( buf.toString() );
            } else {
                throw new IllegalArgumentException("file was empty: "+ff );
            }
            mon.finished();
        } catch (IOException ex) {
            Logger.getLogger(RunScriptPanel.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public JCheckBox getToolsCB() {
        return toolsCB;
    }

    void loadFile(File ff) throws IOException {
        getTextArea().loadFile(ff);
        if ( ff.getCanonicalPath().startsWith( new File( AutoplotSettings.settings().resolveProperty(AutoplotSettings.PROP_AUTOPLOTDATA), "tools" ).getCanonicalPath() ) ) {
            toolsCB.setEnabled(false);
        };
        scriptFilename.setText(ff.toString());
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        toolsCB = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        scriptPanel = new javax.swing.JPanel();
        scriptFilename = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        jLabel1.setText("Run the script:");

        toolsCB.setText("Install in tools folder and menu");

        scriptPanel.setLayout(new java.awt.BorderLayout());
        jScrollPane1.setViewportView(scriptPanel);

        scriptFilename.setText("<html><em>script filename\n");

        jLabel2.setText("Make sure the script does not contain malicious code.");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 409, Short.MAX_VALUE)
                    .add(jLabel1)
                    .add(scriptFilename, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 409, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(toolsCB))
                    .add(jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 409, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .add(3, 3, 3)
                .add(scriptFilename, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 283, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(toolsCB)
                .add(11, 11, 11)
                .add(jLabel2)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel scriptFilename;
    private javax.swing.JPanel scriptPanel;
    private javax.swing.JCheckBox toolsCB;
    // End of variables declaration//GEN-END:variables


}
