/*
 * SaveAsDialog.java
 *
 * Created on November 9, 2007, 11:58 AM
 */

package org.virbo.autoplot;

import org.das2.dasml.PersistentStateSupport;
import java.io.File;
import javax.swing.JFileChooser;

/**
 *
 * @author  jbf
 */
public class SaveAsDialog extends java.awt.Dialog {
    
    PersistentStateSupport stateSupport;
    ApplicationModel application;
    
    /** Creates new form SaveAsDialog */
    public SaveAsDialog(java.awt.Frame parent, PersistentStateSupport stateSupport, ApplicationModel application, boolean modal) {
        super(parent, modal);
        initComponents();
        this.stateSupport= stateSupport;
        this.application= application;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        pick = new javax.swing.JButton();
        fileNameTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        embedDataCB = new javax.swing.JCheckBox();
        bookmarkCB = new javax.swing.JCheckBox();
        okayButton = new javax.swing.JButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        pick.setText("Choose");
        pick.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pickActionPerformed(evt);
            }
        });

        fileNameTextField.setText("jTextField1");

        jLabel1.setText("Filename");

        embedDataCB.setText("embed data within file");
        embedDataCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        embedDataCB.setMargin(new java.awt.Insets(0, 0, 0, 0));

        bookmarkCB.setText("add to bookmarks");
        bookmarkCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        bookmarkCB.setMargin(new java.awt.Insets(0, 0, 0, 0));

        okayButton.setText("OK");
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(layout.createSequentialGroup()
                        .add(fileNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 285, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pick))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(bookmarkCB)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 200, Short.MAX_VALUE)
                                .add(okayButton))
                            .add(embedDataCB))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(pick)
                    .add(fileNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(embedDataCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(bookmarkCB)
                    .add(okayButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonActionPerformed
        application.setUseEmbeddedDataSet( embedDataCB.isSelected() );
        stateSupport.setCurrentFile( new File( fileNameTextField.getText() ) );
        if ( bookmarkCB.isSelected() ) {
            application.addBookmark( fileNameTextField.getText() );
        }
        stateSupport.createSaveAsAction().actionPerformed(evt);
    }//GEN-LAST:event_okayButtonActionPerformed

    private void pickActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pickActionPerformed
        JFileChooser chooser= new JFileChooser();
        chooser.setSelectedFile(stateSupport.getCurrentFile());
        int result= chooser.showSaveDialog( this );
        if ( result==JFileChooser.APPROVE_OPTION ) {
            fileNameTextField.setText( chooser.getSelectedFile().toString() );
        }
    }//GEN-LAST:event_pickActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SaveAsDialog(new java.awt.Frame(), null,null, true).setVisible(true);
            }
        });
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox bookmarkCB;
    private javax.swing.JCheckBox embedDataCB;
    private javax.swing.JTextField fileNameTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton okayButton;
    private javax.swing.JButton pick;
    // End of variables declaration//GEN-END:variables

    /**
     * Utility field used by bound properties.
     */
    private java.beans.PropertyChangeSupport propertyChangeSupport =  new java.beans.PropertyChangeSupport(this);

    /**
     * Adds a PropertyChangeListener to the listener list.
     * @param l The listener to add.
     */
    public void addPropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    /**
     * Removes a PropertyChangeListener from the listener list.
     * @param l The listener to remove.
     */
    public void removePropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    /**
     * Getter for property embedData.
     * @return Value of property embedData.
     */
    public boolean isEmbedData() {
        return  embedDataCB.isSelected();
    }

    /**
     * Setter for property embedData.
     * @param embedData New value of property embedData.
     */
    public void setEmbedData(boolean embedData) {
        boolean oldEmbedData = embedDataCB.isSelected();
        this.embedDataCB.setSelected( embedData );
        propertyChangeSupport.firePropertyChange ("embedData", Boolean.valueOf(oldEmbedData), Boolean.valueOf(embedData));
    }

    /**
     * Getter for property bookmark.
     * @return Value of property bookmark.
     */
    public boolean isBookmark() {
        return this.bookmarkCB.isSelected();
    }

    /**
     * Setter for property bookmark.
     * @param bookmark New value of property bookmark.
     */
    public void setBookmark(boolean bookmark) {
        boolean oldBookmark = isBookmark();
        this.bookmarkCB.setSelected( bookmark );
        propertyChangeSupport.firePropertyChange ("bookmark", Boolean.valueOf(oldBookmark), Boolean.valueOf(bookmark));
    }
    
}
