/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CDAWebDataSetIdDialog.java
 *
 * Created on Dec 3, 2010, 10:53:19 AM
 */

package org.autoplot.cdaweb;

import java.util.Map;
import java.util.Map.Entry;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;

/**
 *
 * @author jbf
 */
public class CDAWebDataSetIdDialog extends javax.swing.JDialog {

    boolean isCancelled= false;
    
    /** Creates new form CDAWebDataSetIdDialog */
    public CDAWebDataSetIdDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    public void refresh() {
        CDAWebDB db= CDAWebDB.getInstance();
        Map<String,String> ids= db.getServiceProviderIds();
        String filter="";
        if ( filterCheckBox.isSelected() ) {
            filter= filterTF.getText().toLowerCase();
        }

        DefaultListModel model= new DefaultListModel();

        for ( Entry<String,String> e: ids.entrySet() ) {
            if ( e.getKey().toLowerCase().contains(filter) || e.getValue().toLowerCase().contains(filter) ) {
               model.addElement( e.getKey() + ": " +e.getValue() );
            }
        }

        dsList.setModel( model );

    }

    public String getSelectedItem() {
        String sel= (String) dsList.getSelectedValue();
        int i= sel.indexOf(":");
        return sel.substring(0,i);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        filterCheckBox = new javax.swing.JCheckBox();
        filterTF = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        dsList = new javax.swing.JList();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jLabel1.setText("Select the dataset to work with:");

        filterCheckBox.setText("Filter");
        filterCheckBox.setToolTipText("Simple filter on ID and description");
        filterCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterCheckBoxActionPerformed(evt);
            }
        });

        filterTF.setToolTipText("filter on ID and description");
        filterTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterTFActionPerformed(evt);
            }
        });
        filterTF.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                filterTFKeyTyped(evt);
            }
        });

        dsList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Refreshing Database, should be just a few seconds..." };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        dsList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane1.setViewportView(dsList);

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText("Ok");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 684, Short.MAX_VALUE)
                        .addContainerGap())
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(cancelButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(okButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 57, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(15, 15, 15))
                    .add(layout.createSequentialGroup()
                        .add(filterCheckBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(filterTF, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 611, Short.MAX_VALUE)
                        .add(24, 24, 24))
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addContainerGap(495, Short.MAX_VALUE))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 339, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(filterTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(filterCheckBox))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(okButton)
                    .add(cancelButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void filterCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterCheckBoxActionPerformed
        refresh();
}//GEN-LAST:event_filterCheckBoxActionPerformed

    private void filterTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterTFActionPerformed
        refresh();
}//GEN-LAST:event_filterTFActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        isCancelled= false;
        setVisible(false);
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        isCancelled= true;
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void filterTFKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_filterTFKeyTyped
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                filterCheckBox.setSelected(true);
                refresh();
            }
        });
    }//GEN-LAST:event_filterTFKeyTyped

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                CDAWebDataSetIdDialog dialog = new CDAWebDataSetIdDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JList dsList;
    private javax.swing.JCheckBox filterCheckBox;
    private javax.swing.JTextField filterTF;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables

    boolean isCancelled() {
        return isCancelled;
    }

    void setFilter(String filter) {
        filterTF.setText(filter);
        if ( filter.length()>0 ) {
            filterCheckBox.setSelected(true);
        }
    }

    String getFilter() {
        return filterTF.getText();
    }
}
