/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SubrangeEditorDialog.java
 *
 * Created on Nov 5, 2009, 10:01:23 AM
 */

package org.autoplot.pngwalk;

import java.util.List;
import javax.swing.UIManager;
import org.das2.datum.DatumRange;

/**
 *
 * @author ed
 */
public class SubrangeEditorDialog extends javax.swing.JDialog {
    private int maxIndex;
    private List<DatumRange> dateSpan;

    private boolean okClicked = false;

    /** Creates new form SubrangeEditorDialog */
    public SubrangeEditorDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        setTitle("Time Range Selection");
        //The GTK L&F displays a value above the slider by default; we make
        // sure it's turned off because it doesn't make any sense in this context
        UIManager.put("Slider.paintValue", Boolean.FALSE);

        initComponents();

    }

    public void setTimeSpan(List<DatumRange> span) {
        dateSpan = span;
        maxIndex = dateSpan.size() - 1;
        startSlider.setValue(0);
        startSlider.setMaximum(maxIndex);
        endSlider.setMaximum(maxIndex);
        endSlider.setValue(maxIndex);

        startLabel.setText(dateSpan.get(startSlider.getValue()).toString());
        endLabel.setText(dateSpan.get(endSlider.getValue()).toString());

    }

    public boolean isOkClicked() {
        return okClicked;
    }

    public int getStartIndex() {
        return startSlider.getValue();
    }

    public void setStartIndex(int in) {
        if (in < 0) in = 0;
        if (in > maxIndex) in = maxIndex;
        if (in > endSlider.getValue()) in = endSlider.getValue();
        startSlider.setValue(in);
    }

    public int getEndIndex() {
        return endSlider.getValue();
    }

    public void setEndIndex(int in) {
        if (in < 0) in = 0;
        if (in > maxIndex) in = maxIndex;
        if (in < startSlider.getValue()) in = startSlider.getValue();
        endSlider.setValue(in);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        startSlider = new javax.swing.JSlider();
        jLabel2 = new javax.swing.JLabel();
        endSlider = new javax.swing.JSlider();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        startLabel = new javax.swing.JLabel();
        endLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jLabel1.setText("Start:");

        startSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                startSliderStateChanged(evt);
            }
        });

        jLabel2.setText("End:");

        endSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                endSliderStateChanged(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        startLabel.setText("(application changes this)");

        endLabel.setText("(application changes this)");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(startSlider, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 441, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(startLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(jLabel2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(endLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 407, Short.MAX_VALUE))
                    .add(endSlider, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 441, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(291, 291, 291)
                        .add(cancelButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 69, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(okButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 75, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(startLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(startSlider, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(endLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(endSlider, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(okButton)
                    .add(cancelButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void startSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_startSliderStateChanged
        startLabel.setText(dateSpan.get(startSlider.getValue()).toString());
        if (startSlider.getValue() > endSlider.getValue()) {
            endSlider.setValue(startSlider.getValue());
        }
    }//GEN-LAST:event_startSliderStateChanged

    private void endSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_endSliderStateChanged
        endLabel.setText(dateSpan.get(endSlider.getValue()).toString());
        if (endSlider.getValue() < startSlider.getValue()) {
            startSlider.setValue(endSlider.getValue());
        }
    }//GEN-LAST:event_endSliderStateChanged

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        okClicked = true;
        setVisible(false);
    }//GEN-LAST:event_okButtonActionPerformed

//    /**
//    * @param args the command line arguments
//    */
//    public static void main(String args[]) {
//        java.awt.EventQueue.invokeLater(new Runnable() {
//            public void run() {
//                SubrangeEditorDialog dialog = new SubrangeEditorDialog(new javax.swing.JFrame(), true);
//                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
//                    public void windowClosing(java.awt.event.WindowEvent e) {
//                        System.exit(0);
//                    }
//                });
//                dialog.setVisible(true);
//            }
//        });
//    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel endLabel;
    private javax.swing.JSlider endSlider;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel startLabel;
    private javax.swing.JSlider startSlider;
    // End of variables declaration//GEN-END:variables

}
