/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AggregatingDataSourceEditorPanel.java
 *
 * Created on Apr 22, 2009, 8:37:48 AM
 */
package org.virbo.aggregator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position.Bias;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.DataSourceEditorPanelUtil;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.SourceTypesBrowser;
import org.virbo.datasource.URISplit;

/**
 *
 * @author jbf
 */
public class AggregatingDataSourceEditorPanel extends javax.swing.JPanel implements DataSourceEditorPanel {

    /** Creates new form AggregatingDataSourceEditorPanel */
    public AggregatingDataSourceEditorPanel() {
        initComponents();
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this, "aggregator_main");
    }
    String uri;
    List<DatumRange> ranges;
    boolean updatingDropLists = false;  // avoid re-entry in droplists.

    public void setDelegateEditorPanel(DataSourceEditorPanel edit) {
        delegateEditorPanel = edit;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        delegatePanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        timeRangeTextField = new javax.swing.JTextField();
        outerRangeTextField = new javax.swing.JLabel();
        yearsComboBox = new javax.swing.JComboBox();
        monthsComboBox = new javax.swing.JComboBox();
        daysComboBox = new javax.swing.JComboBox();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        delegateFileLabel = new javax.swing.JLabel();

        delegatePanel.setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel1.setText("Time Range for Aggregation:");
        jLabel1.setToolTipText("<html>Enter the time range to over which to aggregate data. <br>\nData from files within this range will be combined by concatenating over the first dimension.</br>\n</html>\n\n");

        timeRangeTextField.setText("jTextField1");

        outerRangeTextField.setFont(new java.awt.Font("SansSerif", 0, 10));
        outerRangeTextField.setText("listing to get available time ranges...");

        yearsComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "..." }));
        yearsComboBox.setToolTipText("Select from available years");
        yearsComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                yearsComboBoxItemStateChanged(evt);
            }
        });

        monthsComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "...", " " }));
        monthsComboBox.setToolTipText("Select from available months");
        monthsComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                monthsComboBoxItemStateChanged(evt);
            }
        });

        daysComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "...", " " }));
        daysComboBox.setToolTipText("Select from available days");

        jButton1.setText("Copy");
        jButton1.setToolTipText("<html>\nCopy the date into the time range field.<br>\nHolding shift down will add the selected time to the aggregation.<br>\n</html>");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("jButton2");

        jButton3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/help.png"))); // NOI18N
        jButton3.setToolTipText("Help for this component\n");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        delegateFileLabel.setFont(new java.awt.Font("SansSerif", 0, 10)); // NOI18N
        delegateFileLabel.setText("example file used for editing goes here");
        delegateFileLabel.setToolTipText("Aggregation works by automatically generating a set of \"delegate uris\" that are read and combined into one dataset.  This editor works by picking a delegate and providing an editor for the delegate as well.\n");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(timeRangeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 215, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 208, Short.MAX_VALUE)
                .add(jButton3))
            .add(jPanel1Layout.createSequentialGroup()
                .add(7, 7, 7)
                .add(yearsComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 93, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(monthsComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 88, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(daysComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 72, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton1)
                .addContainerGap(318, Short.MAX_VALUE))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, delegateFileLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 607, Short.MAX_VALUE)
                    .add(outerRangeTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 607, Short.MAX_VALUE))
                .add(26, 26, 26))
        );

        jPanel1Layout.linkSize(new java.awt.Component[] {monthsComboBox, yearsComboBox}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(timeRangeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jButton3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(outerRangeTextField)
                .add(9, 9, 9)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(yearsComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(monthsComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(daysComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jButton1))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(delegateFileLabel)
                .addContainerGap(13, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(delegatePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 649, Short.MAX_VALUE)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(delegatePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 259, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        String syr = String.valueOf(yearsComboBox.getSelectedItem()).trim();
        String smn = String.valueOf(monthsComboBox.getSelectedItem()).trim();
        String sday = String.valueOf(daysComboBox.getSelectedItem()).trim();
        String range = syr + " " + smn + " " + sday;
        range = range.trim();
        if ((evt.getModifiers() & ActionEvent.SHIFT_MASK) == ActionEvent.SHIFT_MASK) {
            DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid(range);
            DatumRange dr2 = null;
            try {
                dr2 = DatumRangeUtil.parseTimeRange(timeRangeTextField.getText());
                dr2 = DatumRangeUtil.union(dr1, dr2);
                timeRangeTextField.setText(dr2.toString());
            } catch (ParseException ex) {
                timeRangeTextField.setText(range);
            }
        } else {
            timeRangeTextField.setText(range);
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void yearsComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_yearsComboBoxItemStateChanged
        if (!updatingDropLists) {
            updateDropLists(false, true);
        }
    }//GEN-LAST:event_yearsComboBoxItemStateChanged

    private void monthsComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_monthsComboBoxItemStateChanged
        if (!updatingDropLists) {
            updateDropLists(false, false);
        }
    }//GEN-LAST:event_monthsComboBoxItemStateChanged

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        AutoplotHelpSystem.getHelpSystem().displayHelpFromEvent(evt,this);
    }//GEN-LAST:event_jButton3ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox daysComboBox;
    private javax.swing.JLabel delegateFileLabel;
    private javax.swing.JPanel delegatePanel;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JComboBox monthsComboBox;
    private javax.swing.JLabel outerRangeTextField;
    private javax.swing.JTextField timeRangeTextField;
    private javax.swing.JComboBox yearsComboBox;
    // End of variables declaration//GEN-END:variables

    public JPanel getPanel() {
        return this;
    }
    JComponent delegateComponent = null;
    DataSetSelector delegateDataSetSelector = null;
    DataSourceEditorPanel delegateEditorPanel = null;
    URISplit split;
    Map<String, String> params;

    private void setDelegateComponent(JComponent c) {
        if (delegateComponent != null) {
            delegatePanel.remove(delegateComponent);
        }
        delegateComponent = c;
        delegatePanel.add(c, BorderLayout.CENTER);
        delegatePanel.validate();
    }

    private void updateTimeRanges() {
        DatumRange dr = null;
        try {
            FileStorageModelNew fsm = AggregatingDataSourceFactory.getFileStorageModel(uri);
            String[] names = fsm.getNamesFor(null, new NullProgressMonitor());
            ranges = new ArrayList(names.length);
            for (int i = 0; i < names.length; i++) {
                ranges.add(i, fsm.getRangeFor(names[i]));
                if (dr == null) {
                    dr = ranges.get(i);
                } else {
                    dr = DatumRangeUtil.union(dr, ranges.get(i));
                }
            }
        } catch (IOException ex) {
            outerRangeTextField.setText(ex.toString());
            return;
        }
        outerRangeTextField.setText("found files for " + dr.toString());
    }

    private void updateDropLists(boolean updateYear, boolean updateMonth) {

        List possible;
        List<DatumRange> result;
        ComboBoxModel model;

        updatingDropLists = true;

        DatumRange selectedRange = null;
        try {
            selectedRange = DatumRangeUtil.parseTimeRange(timeRangeTextField.getText());
        } catch (ParseException ex) {
            Logger.getLogger(AggregatingDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }

        if (updateYear) {
            // years
            possible = DatumRangeUtil.generateList(DatumRangeUtil.parseTimeRangeValid("1800-2200"),
                    DatumRangeUtil.parseTimeRangeValid("1800"));
            result = DatumRangeUtil.intersection(possible, ranges, false);

            String[] yrLabels = new String[result.size() + 1];
            yrLabels[0] = "";
            int isel = result.size() == 1 ? 1 : 0;
            for (int i = 0; i < result.size(); i++) {
                yrLabels[i + 1] = result.get(i).toString();
                if (selectedRange != null && result.get(i).intersects(selectedRange)) {
                    isel = i + 1;
                }
            }
            model = new DefaultComboBoxModel(yrLabels);
            yearsComboBox.setModel(model);
            yearsComboBox.setSelectedIndex(isel);
        }

        String syr = String.valueOf(yearsComboBox.getSelectedItem()).trim();
        if (updateMonth) {
            if (syr.length() > 0) {
                possible = DatumRangeUtil.generateList(DatumRangeUtil.parseTimeRangeValid(syr),
                        DatumRangeUtil.parseTimeRangeValid(syr + " jan"));
                result = DatumRangeUtil.intersection(possible, ranges, false);
                String[] mnLabels = new String[result.size() + 1];
                mnLabels[0] = "";
                int isel = result.size() == 1 ? 1 : 0;
                for (int i = 0; i < result.size(); i++) {
                    mnLabels[i + 1] = result.get(i).toString().replace(syr, "").trim();
                    if (selectedRange != null && result.get(i).intersects(selectedRange) && selectedRange.width().le(result.get(i).width())) {
                        isel = i + 1;
                    }
                }
                model = new DefaultComboBoxModel(mnLabels);
                monthsComboBox.setModel(model);
                monthsComboBox.setSelectedIndex(isel);
            } else {
                monthsComboBox.setModel(new DefaultComboBoxModel(new String[]{""}));
            }
        }

        String smon = String.valueOf(monthsComboBox.getSelectedItem()).trim();
        if (syr.length() > 0 && smon.length() > 0) {
            possible = DatumRangeUtil.generateList(DatumRangeUtil.parseTimeRangeValid(syr + " " + smon),
                    DatumRangeUtil.parseTimeRangeValid(syr + " " + smon + " 1"));
            result = DatumRangeUtil.intersection(possible, ranges, false);
            String[] dayLabels = new String[result.size() + 1];
            dayLabels[0] = "";
            int isel = result.size() == 1 ? 1 : 0;
            for (int i = 0; i < result.size(); i++) {
                dayLabels[i + 1] = String.valueOf(TimeUtil.toTimeStruct(result.get(i).min()).day);
                if (selectedRange != null && result.get(i).intersects(selectedRange) && selectedRange.width().le(result.get(i).width())) {
                    isel = i + 1;
                }
            }
            model = new DefaultComboBoxModel(dayLabels);
            daysComboBox.setModel(model);
            daysComboBox.setSelectedIndex(isel);
        } else {
            daysComboBox.setModel(new DefaultComboBoxModel(new String[]{""}));
        }

        updatingDropLists = false;
    }

    public boolean reject(String uri) throws Exception {
        String delegateUrl = null;
        delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(uri);

        if (delegateEditorPanel == null) {
            delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel( DataSetURI.toUri(delegateUrl) );
        }

        if (delegateEditorPanel == null) {
            return false;
        } else {
            return delegateEditorPanel.reject( delegateUrl );
        }
    }


    public boolean prepare(String url, java.awt.Window parent, ProgressMonitor mon) throws IOException, URISyntaxException, Exception {
        String delegateUrl = null;
        delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(url);

        Pattern p= Pattern.compile("(vap(\\+[a-z]+)?\\:)?([^\\?]*)(\\?.*)");
        Matcher m= p.matcher(delegateUrl);
        if ( m.matches() ) {
            delegateFileLabel.setText( "editing example URI "+ m.group(3) + " above");
        } else {
            delegateFileLabel.setText( "editing example URI  "+ delegateUrl + " above");
        }
        
        if (delegateEditorPanel == null) {
            delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel( DataSetURI.toUri(delegateUrl) );
        }

        if (delegateEditorPanel == null) {
            return true;
        } else {
            return delegateEditorPanel.prepare( delegateUrl, parent, mon );
        }
    }

    /**
     * it's the delegate Data Source Editor is null and we have just an address 
     * bar, then go ahead and do completions.
     */
    public void hintAtCompletion() {
        if ( delegateDataSetSelector!=null ) {
            String text= delegateDataSetSelector.getEditor().getText();
            delegateDataSetSelector.getEditor().setCaretPosition(text.length());
            //delegateDataSetSelector.showCompletions();
            //TODO: bug 3046638: it would be nice if we didn't show "empty" when there are no completions.
        }
        
        // set the focus to the timerange if that's all we need.
        String delegateUrl = null;
        try {
            delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri( getURI() );
            DataSourceFactory dsf= DataSetURI.getDataSourceFactory( DataSetURI.toUri(delegateUrl),new NullProgressMonitor() );
            if ( !dsf.reject( delegateUrl, new NullProgressMonitor() ) ) {
                if ( timeRangeTextField.getText().trim().length()==0 ) {
                    timeRangeTextField.requestFocus();
                }
            }
        } catch ( IOException ex ) {
            
        } catch ( IllegalArgumentException ex ) {
            
        }
    }

    public void setURI(String url) {
        split = URISplit.parse(url);
        params = URISplit.parseParams(split.params);
        this.uri = url;
        try {

            String timeRange = params.get("timerange");
            if (timeRange != null && timeRange.trim().length() > 0) {
                timeRange= timeRange.replaceAll("\\+", " ");
                try {
                    DatumRange dr = DatumRangeUtil.parseTimeRange(timeRange);
                } catch (ParseException ex) {
                    timeRange = "!!! " + timeRange + " !!!";
                }
            }
            timeRangeTextField.setText(timeRange);

            String delegateUrl = null;
            delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(url);

            if (delegateEditorPanel == null) {
                delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel( DataSetURI.toUri(delegateUrl) );
            }
            if (delegateEditorPanel == null) {
                try {
                    DataSetURI.getDataSource(delegateUrl);
                    JPanel delegateP = new JPanel( );
                    BoxLayout l= new BoxLayout(delegateP,BoxLayout.Y_AXIS);
                    delegateP.setLayout(l);
                    delegateP.add( javax.swing.Box.createVerticalGlue() );
                    delegateDataSetSelector = new DataSetSelector();
                    delegateDataSetSelector.setValue(delegateUrl);
                    delegateDataSetSelector.setAlignmentX(Component.LEFT_ALIGNMENT);

                    JTextField jtf= ((DataSetSelector)delegateDataSetSelector).getEditor();

                    int rolimit= delegateUrl.indexOf("?");
                    if ( rolimit==-1 ) rolimit= delegateUrl.length(); else rolimit= rolimit+1;
                    final int frolimit= rolimit;

                    NavigationFilter nf= new NavigationFilter() {

                        @Override
                        public int getNextVisualPositionFrom(JTextComponent text, int pos, Bias bias, int direction, Bias[] biasRet) throws BadLocationException {
                            return super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
                        }

                        @Override
                        public void moveDot(FilterBypass fb, int dot, Bias bias) {
                            if ( dot < frolimit ) dot= frolimit;
                            super.moveDot(fb, dot, bias);
                        }

                        @Override
                        public void setDot(FilterBypass fb, int dot, Bias bias) {
                            if ( dot < frolimit ) dot= frolimit;
                            super.setDot(fb, dot, bias);
                        }

                    };

                    jtf.setNavigationFilter( nf );



                    JLabel la= new JLabel("<html>The delegate data source doesn't provide an editor.  " +
                            "Use this editor to modify parameters, but not the delegate file name.</html>");
                    la.setAlignmentX( Component.LEFT_ALIGNMENT );
                    delegateP.add( la );
                    delegateP.add( delegateDataSetSelector );
                    setDelegateComponent(delegateP);
                } catch ( IllegalArgumentException ex ) {
                    SourceTypesBrowser browser= new SourceTypesBrowser();
                    browser.getDataSetSelector().setValue(delegateUrl);
                    setDelegateComponent(browser);
                }
            } else {
                delegateEditorPanel.setURI(delegateUrl);
                setDelegateComponent(delegateEditorPanel.getPanel());
            }

        } catch (Exception ex) {
            Logger.getLogger(AggregatingDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            RuntimeException ex2 = new RuntimeException("Unable to create example file for aggregation", ex);
            throw ex2;
        }

        Runnable run = new Runnable() {

            public void run() {
                updateTimeRanges();
                updateDropLists(true, true);
            }
        };

        new Thread(run).start();

    }

    public void setTimeRange( DatumRange timerange ) {
        timeRangeTextField.setText( timerange.toString() );
    }

    public DatumRange getTimeRange( ) {
        if ( timeRangeTextField.getText().trim().equals("") ) {
            return null;
        } else {
            try {
                return DatumRangeUtil.parseTimeRange(timeRangeTextField.getText().trim());
            } catch (ParseException ex) {
                return null;
            }
        }
    }

    public String getURI() {
        String delegateUrl;
        String vapScheme= split.vapScheme;
        if (delegateEditorPanel != null) {
            delegateUrl = delegateEditorPanel.getURI();
        } else {
            if ( this.delegateComponent instanceof SourceTypesBrowser ) {
                delegateUrl= ((SourceTypesBrowser)this.delegateComponent).getUri();
                vapScheme= null;
            } else {
                delegateUrl = delegateDataSetSelector.getValue();
            }
        }
        URISplit dsplit = URISplit.parse(delegateUrl);
        Map<String, String> allParams = new LinkedHashMap<String, String>();
        allParams.putAll(params);
        allParams.putAll(URISplit.parseParams(dsplit.params));
        String tr = timeRangeTextField.getText();
        if (tr.startsWith("!!! ")) {
            tr = tr.substring(4);
        }
        if (tr.endsWith(" !!!")) {
            tr = tr.substring(0, tr.length() - 4);
        }
        tr= tr.replaceAll(" ","+");
        allParams.put("timerange", tr);
        split.params = URISplit.formatParams(allParams);
        if ( vapScheme==null ) {
            split.vapScheme= dsplit.vapScheme;
        }
        return URISplit.format(split);
    }
}
