/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AddDataSourcePanel.java
 *
 * Created on Sep 24, 2009, 3:18:09 PM
 */

package org.virbo.autoplot;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.datasource.DataSetSelector;
import org.xml.sax.SAXException;

/**
 * Adds a Data Source to the application.  Note this does not work with Webstart
 * because of security limitations but does with the jumbojar version.
 * TODO: This has not been used in a while and needs attention (PREF_RECENT).
 * @author jbf
 */
public class AddDataSourcePanel extends javax.swing.JPanel {

    public static final String PREF_RECENT = "addDataSourceRecent";

    /** Creates new form AddDataSourcePanel */
    public AddDataSourcePanel() {
        initComponents();
        dataSetSelector1.setBrowseTypeExt("jar");
        dataSetSelector1.setEnableDataSource(false);
        dataSetSelector1.setHidePlayButton(true);

        Preferences prefs = Preferences.userNodeForPackage(AddDataSourcePanel.class);
        String srecent = prefs.get(PREF_RECENT,"");

        if ( !srecent.equals("") ) {
            try {
                List<String> urls = new ArrayList<String>();
                List<Bookmark> recent = Bookmark.parseBookmarks(srecent);
                for (Bookmark b : recent) {
                    urls.add(((Bookmark.Item) b).getUri());
                }
                dataSetSelector1.setRecent(urls);
                if (urls.size() > 1) {
                    dataSetSelector1.setValue(urls.get(urls.size() - 1));
                }
                dataSetSelector1.setRecent(urls);
            } catch (SAXException ex) {
                Logger.getLogger(AddDataSourcePanel.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(AddDataSourcePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            String[] recent= new String[] { "(no recent entries)" };
            dataSetSelector1.setRecent( new ArrayList<String>( Arrays.asList(recent) ) );
            dataSetSelector1.setValue("");
        }

        dataSetSelector1.addPropertyChangeListener( DataSetSelector.PROP_RECENT, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                Preferences prefs = Preferences.userNodeForPackage(AddDataSourcePanel.class);
                List<String> srecent= dataSetSelector1.getRecent();
                List<Bookmark> recent = new ArrayList<Bookmark>();
                for ( String s : srecent ) {
                    recent.add( new Bookmark.Item( s ) );
                }
                prefs.put( PREF_RECENT, Bookmark.formatBooks( recent ) );
            }
        } );

        
    }

    public DataSetSelector getDataSetSelector() {
        return dataSetSelector1;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        dataSetSelector1 = new org.virbo.datasource.DataSetSelector();

        jLabel1.setText("Add Data Sources Found in Jar File:");

        dataSetSelector1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dataSetSelector1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(dataSetSelector1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 384, Short.MAX_VALUE))
                    .add(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(dataSetSelector1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(220, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void dataSetSelector1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dataSetSelector1ActionPerformed
    }//GEN-LAST:event_dataSetSelector1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    public org.virbo.datasource.DataSetSelector dataSetSelector1;
    public javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

}
