/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ExportDataPanel.java
 *
 * Created on Feb 2, 2010, 9:03:23 AM
 */
package org.virbo.autoplot;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.virbo.ascii.AsciiTableDataSourceFormatEditorPanel;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceFormatEditorPanel;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.DataSourceFormat;

/**
 *
 * @author jbf
 */
public class ExportDataPanel extends javax.swing.JPanel {

    /** Creates new form ExportDataPanel */
    public ExportDataPanel() {
        initComponents();
    }

    public void setDataSet(Application model) {
        DataSourceController dsc = model.getController().getDataSourceFilter().getController();

        if (dsc.getFillDataSet() != null) {
            String name = (String) dsc.getFillDataSet().property(QDataSet.NAME);
            if (name != null) {
                filenameTF.setText(name.toLowerCase());
            }
            originalDataB.setToolTipText( String.format( "<html>%s<br>%s</html>", originalDataB.getToolTipText(), dsc.getFillDataSet() ) );
        }

        QDataSet processedDataSet= model.getController().getPlotElement().getController().getDataSet();
        if ( processedDataSet!=null ) {
            if ( !processedDataSet.equals(dsc.getFillDataSet() ) ) {
                processedDataB.setToolTipText( String.format( "<html>%s<br>%s</html>", processedDataB.getToolTipText(), processedDataSet ) );
            } else {
                processedDataB.setToolTipText( String.format( "<html>%s</html>", "No processing is done to the dataset before plotting" ) );
                processedDataB.setEnabled(false);
            }
        } else {
            processedDataB.setEnabled(false);
        }
    }

    public boolean isFormatPlotElement() {
        return processedDataB.isSelected();
    }

    /**
     * format the visible data, trimming to xaxis bounds.
     * @return
     */
    public boolean isFormatPlotElementAndTrim() {
        return processedWithinXRangeB.isSelected();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel2 = new javax.swing.JLabel();
        processedDataB = new javax.swing.JRadioButton();
        originalDataB = new javax.swing.JRadioButton();
        formatDL = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        filenameTF = new javax.swing.JTextField();
        chooseFileB = new javax.swing.JButton();
        additionalOptionsButton = new javax.swing.JButton();
        warningMessageLabel = new javax.swing.JLabel();
        processedWithinXRangeB = new javax.swing.JRadioButton();

        jLabel2.setText("Select Output Format:");

        buttonGroup1.add(processedDataB);
        processedDataB.setText("Processed Data or Component");
        processedDataB.setToolTipText("Data as displayed, including slice and other operations.  This is the loaded data, and may extend past plot boundaries.\n");

        buttonGroup1.add(originalDataB);
        originalDataB.setSelected(true);
        originalDataB.setText("Original Data");
        originalDataB.setToolTipText("Data read in from data source");

        formatDL.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        formatDL.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                formatDLItemStateChanged(evt);
            }
        });
        formatDL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                formatDLActionPerformed(evt);
            }
        });

        jLabel1.setText("Select Data to Export:");

        jLabel3.setText("Filename:");

        filenameTF.setText("data");

        chooseFileB.setText("Select...");
        chooseFileB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseFileBActionPerformed(evt);
            }
        });

        additionalOptionsButton.setText("Additional options for output format...");
        additionalOptionsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                additionalOptionsButtonActionPerformed(evt);
            }
        });

        buttonGroup1.add(processedWithinXRangeB);
        processedWithinXRangeB.setText("Processed Data within X Axis Range");
        processedWithinXRangeB.setToolTipText("Processed data, but also trim to the data to the X axis bounds.\n");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(originalDataB))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(processedDataB)))
                .add(22, 22, 22))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(processedWithinXRangeB)
                .addContainerGap(351, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jLabel3)
                    .add(layout.createSequentialGroup()
                        .add(additionalOptionsButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 274, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(formatDL, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(jLabel2)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(filenameTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 508, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(chooseFileB)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(warningMessageLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 602, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(originalDataB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(processedDataB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(processedWithinXRangeB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(warningMessageLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 23, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(formatDL, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jLabel3)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(filenameTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(chooseFileB))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(additionalOptionsButton)
                .addContainerGap(94, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void chooseFileBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseFileBActionPerformed

        JFileChooser chooser = new JFileChooser();

        List<String> exts = DataSourceRegistry.getInstance().getFormatterExtensions();
        FileFilter deflt = null;
        for (String ext : exts) {
            final String ex = ext;

            FileFilter ff = new FileFilter() {

                @Override
                public boolean accept(File f) {
                    if ( f.toString()==null ) return false;
                    return f.toString().endsWith(ex) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "*" + ex; // DANGER: this is parsed below
                }
            };
            if (ext.equals(".qds")) {
                deflt = ff;
            }
            chooser.addChoosableFileFilter(ff);
        }

        chooser.setFileFilter(deflt);

        int r = chooser.showSaveDialog(this);
        if (r == JFileChooser.APPROVE_OPTION) {
            String s = chooser.getSelectedFile().toString();

            String ext = DataSetURI.getExt(s);
            if (ext == null) {
                ext = "";
            }

            DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
            if (format == null) {
                if (chooser.getFileFilter().getDescription().startsWith("*.")) {
                    ext = chooser.getFileFilter().getDescription().substring(1);
                    format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                    if (format == null) {
                        JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                        return;
                    } else {
                        s = s + ext;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                    return;
                }
            }
            filenameTF.setText( s );
            formatDL.setSelectedItem("."+ext);
            
        }
    }//GEN-LAST:event_chooseFileBActionPerformed

    private void formatDLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_formatDLActionPerformed
        String ff= filenameTF.getText();
        if ( ! ff.endsWith( (String)formatDL.getSelectedItem() ) ) {
            int ii2= ff.lastIndexOf("/");
            if ( ii2==-1 ) ii2= 0;
            int ii= ff.lastIndexOf(".");
            if ( ii>-1 && ii>ii2 ) {
                filenameTF.setText(ff.substring(0,ii) + formatDL.getSelectedItem() );
            }
        }
    }//GEN-LAST:event_formatDLActionPerformed

    private void formatDLItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_formatDLItemStateChanged
        String ss=  (String) evt.getItem();

        if ( ss.equals(".txt") || ss.equals(".dat") ) { //TODO: hard coded for ASCII
            editorPanel= new AsciiTableDataSourceFormatEditorPanel();
            String t=  getFilenameTF().getText();
            if ( t.contains("/" ) ) {
                editorPanel.setURI( getFilenameTF().getText() );
            }
        } else if ( ss.equals(".csv" ) ) {
            editorPanel= null;

        } else {
            Object oeditorPanel= DataSourceRegistry.getInstance().getDataSourceFormatEditorByExt(ss);
            if ( oeditorPanel!=null ) {
                if ( oeditorPanel instanceof String ) {
                    editorPanel= (DataSourceFormatEditorPanel)DataSourceRegistry.getInstanceFromClassName( (String)oeditorPanel );
                    if ( editorPanel==null ) throw new IllegalArgumentException("unable to create instance: "+oeditorPanel);
                } else {
                    editorPanel= (DataSourceFormatEditorPanel)oeditorPanel;
                }
                String t=  getFilenameTF().getText();
                if ( t.contains("/" ) ) {
                    editorPanel.setURI( getFilenameTF().getText() );
                }
            } else {
                editorPanel= null;
            }
        }

        additionalOptionsButton.setEnabled(editorPanel!=null);

    }//GEN-LAST:event_formatDLItemStateChanged

    private void additionalOptionsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_additionalOptionsButtonActionPerformed
        javax.swing.JPanel j= editorPanel.getPanel();
        JOptionPane.showConfirmDialog( this, j, "Additional Options", JOptionPane.OK_CANCEL_OPTION );
    }//GEN-LAST:event_additionalOptionsButtonActionPerformed

    DataSourceFormatEditorPanel editorPanel=null;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton additionalOptionsButton;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton chooseFileB;
    private javax.swing.JTextField filenameTF;
    private javax.swing.JComboBox formatDL;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JRadioButton originalDataB;
    private javax.swing.JRadioButton processedDataB;
    private javax.swing.JRadioButton processedWithinXRangeB;
    private javax.swing.JLabel warningMessageLabel;
    // End of variables declaration//GEN-END:variables

    /**
     * @return the filenameTF
     */
    public javax.swing.JTextField getFilenameTF() {
        return filenameTF;
    }

    /**
     * @return the formatDL
     */
    public javax.swing.JComboBox getFormatDL() {
        return formatDL;
    }

    public DataSourceFormatEditorPanel getDataSourceFormatEditorPanel() {
        return editorPanel;
    }

    void setFile(String currentFileString) {
        URISplit split= URISplit.parse(currentFileString);
        this.filenameTF.setText(split.file);
        formatDLActionPerformed(null);
        if ( editorPanel!=null ) {
            editorPanel.setURI(currentFileString);
        }
    }

    void setTsb(boolean b) {
        if ( b ) {
            warningMessageLabel.setText("Exporting data at native resolution.");
            warningMessageLabel.setToolTipText("<html>This data comes from a reader that can return data at multiple resolutions.  Data will be reread at native resolution before writing output.</html>");
        } 
    }

}
