/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ImportVapDialog.java
 *
 * Created on Sep 21, 2010, 1:41:23 PM
 */

package org.virbo.autoplot;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.das2.components.DasProgressPanel;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.state.StatePersistence;
import org.virbo.datasource.DataSetURI;


/**
 *
 * @author jbf
 */
public class ImportVapDialog extends javax.swing.JPanel {

    List<String> dataSets;
    List<JCheckBox> sels;

    /** Creates new form ImportVapDialog */
    public ImportVapDialog() {
        initComponents();
    }

    /**
     * returns JOptionPane.OKAY_OPTION or JOptionPane.CANCEL_OPTION
     * @return
     */
    public int showDialog( Component parent ) {
        return JOptionPane.showConfirmDialog( parent, sels.toArray(), "Import URIs", JOptionPane.OK_CANCEL_OPTION );
    }

    public void setVap( String vap ) throws IOException {
        ProgressMonitor mon= DasProgressPanel.createFramed("loading vap");
        File f= DataSetURI.getFile( DataSetURI.getResourceURI(vap), mon );
        Application app= (Application)StatePersistence.restoreState(f);
        DataSourceFilter[] dsfs= app.getDataSourceFilters();
        dataSets= new ArrayList();
        sels= new ArrayList();
        for ( DataSourceFilter dsf: dsfs ) {
            if ( dsf.getUri().startsWith("vap+internal") ) {

            } else {
                String s=  dsf.getUri();
                int i= s.lastIndexOf("/");
                JCheckBox mi;
                if ( i==-1 ) {
                    mi= new JCheckBox( "<html>"+s+"</html>");
                } else {
                    mi= new JCheckBox( "<html>"+s.substring(0,i+1)+"<br>"+s.substring(i+1)+"</html>");
                }
                sels.add( mi );
                dataSets.add(s);
            }
        }
    }

    public List<String> getSelectedURIs() {
        List<String> result= new ArrayList();
        for ( int i=0; i<sels.size(); i++ ) {
            if ( sels.get(i).isSelected() ) {
                result.add( dataSets.get(i) );
            }
        }
        return result;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        dataSetsPanel = new javax.swing.JPanel();

        jLabel1.setText("Import Datasets:");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(dataSetsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 541, Short.MAX_VALUE)
                    .add(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(dataSetsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 609, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JPanel dataSetsPanel;
    public javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    
}
