/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * LogConsoleSettingsDialog.java
 *
 * Created on May 19, 2009, 7:32:38 AM
 */

package org.virbo.autoplot.scriptconsole;

import java.util.logging.Level;

/**
 *
 * @author jbf
 */
public class LogConsoleSettingsDialog extends javax.swing.JDialog {

    LogConsole console;

    /** Creates new form LogConsoleSettingsDialog */
    public LogConsoleSettingsDialog(java.awt.Frame parent, boolean modal, LogConsole console ) {
        super(parent, modal);
        initComponents();
        this.console= console;
    }

    private void updateSearchText() {
        console.setSearchText( searchForTextField.getText() );
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        loggerIDCheckBox = new javax.swing.JCheckBox();
        timeStampsCheckBox = new javax.swing.JCheckBox();
        logLevelCheckBox = new javax.swing.JCheckBox();
        verbositySelect = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        searchForTextField = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        loggerIDCheckBox.setText("logger ID");
        loggerIDCheckBox.setToolTipText("identifies the logger posting the message");
        loggerIDCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loggerIDCheckBoxActionPerformed(evt);
            }
        });

        timeStampsCheckBox.setText("timing");
        timeStampsCheckBox.setToolTipText("Show time of the message, in seconds before the most recent message.");
        timeStampsCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                timeStampsCheckBoxActionPerformed(evt);
            }
        });

        logLevelCheckBox.setText("log levels");
        logLevelCheckBox.setToolTipText("show the log level (verbosity) of the messages.");
        logLevelCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                logLevelCheckBoxActionPerformed(evt);
            }
        });

        verbositySelect.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "warnings", "informational", "debug (fine)", "debug (finer)", "debug (finest)", "all" }));
        verbositySelect.setToolTipText("filter messages by verbosity.");
        verbositySelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                verbositySelectActionPerformed(evt);
            }
        });

        jLabel1.setText("Verbosity:");

        jLabel2.setText("Highlite Lines Matching:");
        jLabel2.setToolTipText("Enter a regular expression.  Lines containing this will be highlited.");

        searchForTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                searchForTextFieldActionPerformed(evt);
            }
        });
        searchForTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                searchForTextFieldFocusLost(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                            .add(loggerIDCheckBox)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(timeStampsCheckBox)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(logLevelCheckBox))
                        .add(layout.createSequentialGroup()
                            .add(jLabel1)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(verbositySelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 147, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(layout.createSequentialGroup()
                        .add(jLabel2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(searchForTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 172, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .add(169, 169, 169))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(verbositySelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(timeStampsCheckBox)
                    .add(logLevelCheckBox)
                    .add(loggerIDCheckBox))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(searchForTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(47, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void loggerIDCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loggerIDCheckBoxActionPerformed
        console.setShowLoggerId( loggerIDCheckBox.isSelected() );
        console.update();
}//GEN-LAST:event_loggerIDCheckBoxActionPerformed

    private void timeStampsCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_timeStampsCheckBoxActionPerformed
        console.setShowTimeStamps( timeStampsCheckBox.isSelected() );
        console.update();
}//GEN-LAST:event_timeStampsCheckBoxActionPerformed

    private void logLevelCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_logLevelCheckBoxActionPerformed
        console.setShowLevel( logLevelCheckBox.isSelected() );
        console.update();
}//GEN-LAST:event_logLevelCheckBoxActionPerformed

    private void verbositySelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_verbositySelectActionPerformed
        String o = (String) verbositySelect.getSelectedItem();

        Level level;
        if (o.equals("warnings")) {
            level = Level.WARNING;
        } else if (o.equals("informational")) {
            level = Level.INFO;
        } else if (o.equals("debug (fine)")) {
            level = Level.FINE;
        } else if (o.equals("debug (finer)")) {
            level = Level.FINER;
        } else if (o.equals("debug (finest)")) {
            level = Level.FINEST;
        } else if (o.equals("all")) {
            level = Level.ALL;
        } else {
            throw new RuntimeException("bad level string: " + o);
        }
        console.setLevel( level.intValue() );
        console.update();
}//GEN-LAST:event_verbositySelectActionPerformed

    private void searchForTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchForTextFieldActionPerformed
        updateSearchText();
}//GEN-LAST:event_searchForTextFieldActionPerformed

    private void searchForTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_searchForTextFieldFocusLost
        updateSearchText();
    }//GEN-LAST:event_searchForTextFieldFocusLost

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                LogConsoleSettingsDialog dialog = new LogConsoleSettingsDialog(new javax.swing.JFrame(), true, null );
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JCheckBox logLevelCheckBox;
    private javax.swing.JCheckBox loggerIDCheckBox;
    private javax.swing.JTextField searchForTextField;
    private javax.swing.JCheckBox timeStampsCheckBox;
    private javax.swing.JComboBox verbositySelect;
    // End of variables declaration//GEN-END:variables

}
