/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SourceTypesBrowser.java
 *
 * Created on Sep 10, 2009, 6:09:09 AM
 */

package org.virbo.datasource;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

/**
 * Dialog for explcitly selecting data source type.
 * @author jbf
 */
public class SourceTypesBrowser extends javax.swing.JPanel {

    List<String> types;

    /** Creates new form SourceTypesBrowser */
    public SourceTypesBrowser() {
        initComponents();
        initTypes();
        dataSetSelector1.setHidePlayButton(true);
        dataSetSelector1.setDisableDataSources(true);
    }

    public DataSetSelector getDataSetSelector() {
        return dataSetSelector1;
    }

    private void initTypes() {
        DefaultComboBoxModel model= new DefaultComboBoxModel();
        List<CompletionContext> cc= DataSourceRegistry.getInstance().getPlugins();
        types= new ArrayList(cc.size());
        for ( int i=0; i<cc.size(); i++ ) {
            String label= cc.get(i).completable;
            label= label.substring(4,label.length()-1);//vap+
            model.insertElementAt(label,i);
            types.add(i,label );
        }
        this.sourceTypesComboBox.setModel(model);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        sourceTypesComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        dataSetSelector1 = new org.virbo.datasource.DataSetSelector();
        jLabel3 = new javax.swing.JLabel();

        sourceTypesComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jLabel1.setText("Select Data Source Type:");

        jLabel2.setText("Select File:");

        jLabel3.setText("Source Types Browser");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 381, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(27, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(sourceTypesComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jLabel1))
                .addContainerGap(246, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(dataSetSelector1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(jLabel2))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(15, 15, 15)
                .add(jLabel3)
                .add(18, 18, 18)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sourceTypesComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(20, 20, 20)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(dataSetSelector1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.virbo.datasource.DataSetSelector dataSetSelector1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JComboBox sourceTypesComboBox;
    // End of variables declaration//GEN-END:variables

    public String getUri() {
        return "vap+"+types.get( sourceTypesComboBox.getSelectedIndex() ) + ":" + dataSetSelector1.getValue();
    }

}
