/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * JythonEditorPanel.java
 *
 * Created on Jul 14, 2009, 10:44:41 AM
 */

package org.virbo.datasource.jython;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.jython.JythonDataSourceFactory.Param;
import org.virbo.jythonsupport.JythonUtil;
import org.virbo.jythonsupport.ui.EditorAnnotationsSupport;
import org.virbo.jythonsupport.ui.ScriptPanelSupport;

/**
 *
 * @author jbf
 */
public class JythonEditorPanel extends javax.swing.JPanel implements DataSourceEditorPanel {

    ScriptPanelSupport support;
    String suri;
    File file;
    boolean hasVariables= false;
    List<JTextField> tflist;
    List<String> paramsList;
    List<String> deftsList;
    List<Character> typesList;  // only 'A' and 'F' right now

    /** Creates new form JythonEditorPanel */
    public JythonEditorPanel() {
        initComponents();
        tearoffTabbedPane1.hideMouseAdapter();

        support= new ScriptPanelSupport(textArea);
        support.addCaretLabel(caretPositionLabel);
        support.addFileLabel(fileNameLabel);

        jScrollPane1.getVerticalScrollBar().setUnitIncrement(12); //TODO: should be font height

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        variableComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        tearoffTabbedPane1 = new org.das2.components.TearoffTabbedPane();
        scriptPanel = new javax.swing.JPanel();
        caretPositionLabel = new javax.swing.JLabel();
        fileNameLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        textArea = new org.virbo.jythonsupport.ui.EditorTextPane();
        paramsPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();

        variableComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "(running script)" }));

        jLabel1.setText("dataset variable:");
        jLabel1.setToolTipText("The dataset pointed to by the URI");

        caretPositionLabel.setText("1,1");

        fileNameLabel.setMinimumSize(new java.awt.Dimension(200, 16));

        jPanel1.setLayout(new java.awt.BorderLayout());
        jPanel1.add(textArea, java.awt.BorderLayout.CENTER);

        jScrollPane1.setViewportView(jPanel1);

        org.jdesktop.layout.GroupLayout scriptPanelLayout = new org.jdesktop.layout.GroupLayout(scriptPanel);
        scriptPanel.setLayout(scriptPanelLayout);
        scriptPanelLayout.setHorizontalGroup(
            scriptPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, scriptPanelLayout.createSequentialGroup()
                .add(fileNameLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 420, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(caretPositionLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 56, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 482, Short.MAX_VALUE)
        );
        scriptPanelLayout.setVerticalGroup(
            scriptPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, scriptPanelLayout.createSequentialGroup()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 208, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(scriptPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(fileNameLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(caretPositionLabel)))
        );

        tearoffTabbedPane1.addTab("script", scriptPanel);

        paramsPanel.setLayout(new javax.swing.BoxLayout(paramsPanel, javax.swing.BoxLayout.Y_AXIS));
        tearoffTabbedPane1.addTab("params", paramsPanel);

        jLabel2.setText("Select from the variables calculated by the script, 'data' is used by default:");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(variableComboBox, 0, 351, Short.MAX_VALUE)
                .addContainerGap())
            .add(tearoffTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 494, Short.MAX_VALUE)
            .add(layout.createSequentialGroup()
                .add(jLabel2)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(tearoffTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE)
                .add(2, 2, 2)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(variableComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel caretPositionLabel;
    protected javax.swing.JLabel fileNameLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel paramsPanel;
    private javax.swing.JPanel scriptPanel;
    private org.das2.components.TearoffTabbedPane tearoffTabbedPane1;
    private org.virbo.jythonsupport.ui.EditorTextPane textArea;
    private javax.swing.JComboBox variableComboBox;
    // End of variables declaration//GEN-END:variables

    public JPanel getPanel() {
        return this;
    }

    private boolean doVariables( File f, Map<String,String> params ) {

        Map<String,JythonDataSourceFactory.Param> parms;

        boolean hasVars= false;
        tflist= new ArrayList();
        paramsList= new ArrayList();
        deftsList= new ArrayList();
        typesList= new ArrayList();
        
        try {
            parms= JythonDataSourceFactory.getParams( f.toURI(), new NullProgressMonitor() );

            paramsPanel.add( new JLabel("<html>This script has these input parameters.  Buttons on the right show default values.<br><br></html>") );

            for ( Entry<String,Param> e: parms.entrySet() ) {
                //String s= e.getKey();
                JythonDataSourceFactory.Param parm= e.getValue();
                
                String vname= parm.name;                
                String label= parm.label;

                if ( parm.doc==null ) {
                    label= vname+ ":";
                } else {
                    String doc= parm.doc;
                    doc= doc.substring(1,doc.length()-1);// pop off the quotes
                    if ( !parm.label.equals(parm.name) ) {
                        doc= doc + " ("+parm.label+" internally)";
                    }
                    label= "<html>" + parm.name + ", <em>" + doc + "</em>:</html>";
                }      
                
                
                JLabel l= new JLabel( label );
                l.setAlignmentX( JComponent.LEFT_ALIGNMENT );
                paramsPanel.add( l );

                JPanel valuePanel= new JPanel(  );
                valuePanel.setLayout( new BoxLayout( valuePanel, BoxLayout.X_AXIS ) );

                JTextField tf= new JTextField(50);
                Dimension x= tf.getPreferredSize();
                x.width= Integer.MAX_VALUE;
                tf.setMaximumSize(x);
                tf.setAlignmentX( JComponent.LEFT_ALIGNMENT );

                String val;
                if ( params.get(vname)!=null ) {
                    val= params.get(vname);
                    if ( val.startsWith("'") ) val= val.substring(1);
                    if ( val.endsWith("'") ) val= val.substring(0,val.length()-1);
                } else {
                    val= String.valueOf( parm.deft );
                }

                tf.setText( val );
                valuePanel.add( tf );

                final String fdeft= String.valueOf(parm.deft);
                final JTextField ftf= tf;
                JButton defaultButton= new JButton( new AbstractAction( fdeft ) {
                    public void actionPerformed( ActionEvent e ) {
                        ftf.setText(fdeft);
                    }
                });
                defaultButton.setToolTipText("Click to reset to default");
                valuePanel.add( defaultButton );
                valuePanel.setAlignmentX( JComponent.LEFT_ALIGNMENT );
                
                paramsPanel.add( valuePanel );
                tflist.add(tf);
                    paramsList.add( parm.name );
                    deftsList.add( String.valueOf( parm.deft ) );
                    typesList.add( parm.type );

                    hasVars= true;
            }
                
            hasVars= parms.size()>0;

            if ( !hasVars ) {
                paramsPanel.add( new JLabel("<html><em>no parameters</em></html>") );

            }

            paramsPanel.add( Box.createVerticalGlue() );

        } catch (IOException ex) {
            Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return hasVars;

    }

    public void setURI(String url) {
        try {
            this.suri= url;
            URISplit split= URISplit.parse(suri);

            File f = DataSetURI.getFile( DataSetURI.getResourceURI( DataSetURI.toUri(url) ), new NullProgressMonitor());

            support.loadFile(f);
            Map<String,String> results= JythonDataSourceFactory.getParameters(url, new NullProgressMonitor() );
            String[] dropList= new String[results.size()+1];
            int i=0;
            int idx= -1;

            Map<String,String> params= URISplit.parseParams(split.params);

            String param= params.remove("arg_0");

            dropList[0]= "";
            for ( Entry<String,String> ent: results.entrySet()  ) {
                dropList[i+1]= ent.getKey()+":  "+ent.getValue();
                if ( param!=null && param.equals(ent.getKey()) ) {
                    idx= i+1;
                }
                i++;
            }
            variableComboBox.setModel( new DefaultComboBoxModel( dropList ) );
            if ( idx>=0 ) {
                variableComboBox.setSelectedIndex(idx);
            } else {
                variableComboBox.setSelectedIndex(0);
            }

            hasVariables= doVariables(f,params);

            if ( hasVariables ) {
                tearoffTabbedPane1.setSelectedIndex(1);
            }

            List<String> errs= new ArrayList();
            if ( JythonUtil.pythonLint( f.toURI(), errs) ) {
                System.err.println(errs);
                EditorAnnotationsSupport esa= textArea.getEditorAnnotationsSupport();
                for ( String s: errs ) {
                    String[] ss= s.split(":",2);
                    try {
                        String doc= ss[1];
                        doc= doc.replaceAll("<", "&lt;");
                        doc= doc.replaceAll(">", "&gt;");
                        esa.annotateLine(Integer.parseInt(ss[0]), EditorAnnotationsSupport.ANNO_WARNING, "variable is defined before execution: " + doc);
                    } catch (BadLocationException ex) {
                        Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }

            }



        } catch (IOException ex) {
            Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getURI() {
        URISplit split=  URISplit.parse(suri);

        Map<String,String> params= URISplit.parseParams(split.params);

        String param= (String)variableComboBox.getSelectedItem();
        int i= param.indexOf(":");
        if ( i==-1 ) {
            params.put( "arg_0", param.trim() );
        } else {
            params.put( "arg_0", param.substring(0,i).trim() );
        }

        for ( int j=0; j<paramsList.size(); j++ ) {
            String name= paramsList.get(j);
            String value= tflist.get(j).getText();
            String deft= deftsList.get(j);
            char type= typesList.get(j);

            if ( !value.equals(deft) || params.containsKey(name) ) {
                if ( type=='A' ) {
                    value= value.replaceAll("\'", "");
                    if ( !( value.startsWith("'") && value.endsWith("'") ) ) {
                        value=  "'" + value + "'";
                    }
                    params.put( name, value );
                } else {
                    params.put( name, value );
                }
            }
        }

        split.params= URISplit.formatParams(params);

        if ( support.isDirty() ) {
            try {
                FileWriter writer = new FileWriter(support.getFile());
                writer.write( textArea.getText() );
                writer.close();
            } catch (IOException ex) {
                Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return URISplit.format(split);
    }

    public boolean reject(String uri) throws Exception {
        URISplit split= URISplit.parse(uri);
        if ( split.file==null || split.file.length()==0 || split.file.equals("file:///") ) {
            return true;
        } else {
            return false;
        }
    }


    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        DataSetURI.getFile( DataSetURI.getResourceURI( DataSetURI.toUri(uri) ), mon );
        return true;
    }

}
