/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.WritableDataSet;

public class ArrayDataSet
extends AbstractDataSet
implements WritableDataSet {
    double[] data;

    public static ArrayDataSet copy(DataSet ds) {
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("only rank 1 supported");
        }
        ArrayDataSet result = new ArrayDataSet(new double[ds.length()]);
        for (int i = 0; i < ds.length(); ++i) {
            double d = ds.value(i);
            result.putValue(i, d);
        }
        result.putProperty("UNITS", ds.property("UNITS"));
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        result.putProperty("plane0", ds.property("plane0"));
        return result;
    }

    public ArrayDataSet(double[] data) {
        this.data = data;
    }

    public int rank() {
        return 1;
    }

    public double value(int i) {
        return this.data[i];
    }

    public int length() {
        return this.data.length;
    }

    public void putProperty(String name, Object o) {
        this.properties.put(name, o);
    }

    public void putValue(int i, double d) {
        this.data[i] = d;
    }

    public void putValue(int i0, int i1, double d) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    public void putValue(int i0, int i1, int i2, double d) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }
}

