/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.WritableDataSet;

public final class DDataSet
extends AbstractDataSet
implements WritableDataSet {
    double[] back;
    int rank;
    int len0;
    int len1;
    int len2;
    public static final String version = "20070529";

    public static DDataSet createRank1(int len0) {
        return new DDataSet(1, len0, 1, 1);
    }

    public static DDataSet createRank2(int len0, int len1) {
        return new DDataSet(2, len0, len1, 1);
    }

    public static DDataSet createRank3(int len0, int len1, int len2) {
        return new DDataSet(3, len0, len1, len2);
    }

    private DDataSet(int rank, int len0, int len1, int len2) {
        this(rank, len0, len1, len2, new double[len0 * len1 * len2]);
    }

    private DDataSet(int rank, int len0, int len1, int len2, double[] back) {
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.len0;
    }

    public int length(int i) {
        return this.len1;
    }

    public int length(int i0, int i1) {
        return this.len2;
    }

    public double value(int i0) {
        return this.back[i0];
    }

    public double value(int i0, int i1) {
        return this.back[i0 * this.len1 + i1];
    }

    public double value(int i0, int i1, int i2) {
        return this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
    }

    public void putValue(int i0, double value) {
        this.back[i0] = value;
    }

    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = value;
    }

    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = value;
    }

    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }

    private static Map copyProperties(DataSet ds) {
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] names = new String[]{"VALID_RANGE", "CADENCE", "FILL", "MONOTONIC", "SCALE_TYPE", "TYPICAL_RANGE", "UNITS", "VALID_RANGE"};
        for (i = 0; i < names.length; ++i) {
            if (ds.property(names[i]) == null) continue;
            result.put(names[i], ds.property(names[i]));
        }
        for (i = 0; i < ds.rank(); ++i) {
            DataSet dep = (DataSet)ds.property("DEPEND_" + i);
            if (dep == null) continue;
            result.put("DEPEND_" + i, DDataSet.copy(dep));
        }
        DataSet plane0 = (DataSet)ds.property("PLANE_0");
        if (plane0 != null) {
            result.put("PLANE_0", DDataSet.copy(plane0));
        }
        return result;
    }

    private static DDataSet ddcopy(DDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2;
        double[] newback = new double[dsLength];
        System.arraycopy(ds.back, 0, newback, 0, dsLength);
        DDataSet result = new DDataSet(ds.rank, ds.len0, ds.len1, ds.len2, newback);
        result.properties.putAll(DDataSet.copyProperties(ds));
        return result;
    }

    public static DDataSet copy(DataSet ds) {
        DDataSet result;
        if (ds instanceof DDataSet) {
            return DDataSet.ddcopy((DDataSet)ds);
        }
        int rank = ds.rank();
        switch (rank) {
            case 1: {
                result = DDataSet.createRank1(ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                result = DDataSet.createRank2(ds.length(), ds.length(0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                result = DDataSet.createRank3(ds.length(), ds.length(0), ds.length(0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(DDataSet.copyProperties(ds));
        return result;
    }

    public static DDataSet wrap(double[] back) {
        return new DDataSet(1, back.length, 1, 1, back);
    }

    public static DDataSet wrap(double[] back, int nx, int ny) {
        return new DDataSet(1, nx, ny, 1, back);
    }

    private void joinProperties(DDataSet ds) {
        HashMap<String, DDataSet> result = new HashMap<String, DDataSet>();
        for (int i = 0; i < ds.rank(); ++i) {
            DataSet dep1 = (DataSet)ds.property("DEPEND_" + i);
            if (dep1 == null) continue;
            DataSet dep0 = (DataSet)this.property("DEPEND_" + i);
            DDataSet djoin = DDataSet.copy(dep0);
            DDataSet ddep1 = dep1 instanceof DDataSet ? (DDataSet)dep1 : DDataSet.copy(dep1);
            djoin.join(ddep1);
            result.put("DEPEND_" + i, djoin);
        }
        DataSet dep1 = (DataSet)ds.property("PLANE_0");
        if (dep1 != null) {
            DataSet dep0 = (DataSet)this.property("PLANE_0");
            DDataSet djoin = DDataSet.copy(dep0);
            DDataSet dd1 = dep1 instanceof DDataSet ? (DDataSet)dep1 : DDataSet.copy(dep1);
            djoin.join(dd1);
            result.put("PLANE_0", djoin);
        }
        this.properties.putAll(result);
    }

    public static void copyElements(DDataSet src, int srcpos, DDataSet dest, int destpos, int len) {
        if (src.len1 != dest.len1 || src.len2 != dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        int srcpos1 = srcpos * src.len1 * src.len2;
        int destpos1 = destpos * src.len1 * src.len2;
        int len1 = len * src.len1 * src.len2;
        System.arraycopy(src.back, srcpos1, dest.back, destpos1, len1);
    }

    public void join(DDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2;
        int dsLength = ds.len0 * ds.len1 * ds.len2;
        double[] newback = new double[myLength + dsLength];
        System.arraycopy(this.back, 0, newback, 0, myLength);
        System.arraycopy(ds.back, 0, newback, myLength, dsLength);
        this.len0 += ds.len0;
        this.back = newback;
        this.joinProperties(ds);
    }
}

