/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import org.virbo.dataset.AbstractDataSet;

public class DataSetAdapter {
    public static final String PROPERTY_SOURCE = "adapterSource";

    public static AbstractDataSet create(DataSet ds) {
        if (ds instanceof VectorDataSet) {
            return new Vector((VectorDataSet)ds);
        }
        if (ds instanceof TableDataSet) {
            return new Table((TableDataSet)ds);
        }
        throw new IllegalArgumentException("unsupported dataset type: " + ds.getClass().getName());
    }

    static class Table
    extends AbstractDataSet {
        TableDataSet source;

        Table(TableDataSet source) {
            if (source.tableCount() > 1) {
                throw new IllegalArgumentException("only simple tables are supported");
            }
            this.source = source;
            this.properties.put("UNITS", source.getZUnits());
            this.properties.put("DEPEND_0", new XTagsDataSet((DataSet)source));
            this.properties.put("DEPEND_1", new YTagsDataSet(source));
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
        }

        public int rank() {
            return 2;
        }

        public int length(int i) {
            return this.source.getYLength(0);
        }

        public double value(int i, int j) {
            return this.source.getDouble(i, j, this.source.getZUnits());
        }

        public int length() {
            return this.source.getXLength();
        }

        public void putProperty(String name, Object value) {
            throw new IllegalArgumentException("not supported");
        }

        public void putProperty(String name, int index, Object value) {
            throw new IllegalArgumentException("not supported");
        }

        public void putProperty(String name, int index1, int index2, Object value) {
            throw new IllegalArgumentException("not supported");
        }
    }

    static class YTagsDataSet
    extends AbstractDataSet {
        TableDataSet source;

        YTagsDataSet(TableDataSet source) {
            this.source = source;
            this.properties.put("UNITS", source.getYUnits());
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getYTagDouble(0, i, this.source.getYUnits());
        }

        public int length() {
            return this.source.getYLength(0);
        }
    }

    static class Vector
    extends AbstractDataSet {
        VectorDataSet source;

        Vector(VectorDataSet source) {
            this.source = source;
            this.properties.put("UNITS", source.getYUnits());
            this.properties.put("DEPEND_0", new XTagsDataSet((DataSet)source));
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getDouble(i, this.source.getYUnits());
        }

        public int length() {
            return this.source.getXLength();
        }
    }

    static class XTagsDataSet
    extends AbstractDataSet {
        DataSet source;

        XTagsDataSet(DataSet source) {
            this.source = source;
            this.properties.put("UNITS", source.getXUnits());
            Object o = source.getProperty("xMonotonic");
            if (o != null) {
                this.properties.put("MONOTONIC", o);
            }
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getXTagDouble(i, this.source.getXUnits());
        }

        public int length() {
            return this.source.getXLength();
        }

        public void putProperty(String name, int index1, int index2, Object value) {
            throw new IllegalArgumentException("not supported");
        }

        public void putProperty(String name, int index, Object value) {
            throw new IllegalArgumentException("not supported");
        }

        public void putProperty(String name, Object value) {
            throw new IllegalArgumentException("not supported");
        }
    }
}

