/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Arrays;
import java.util.Comparator;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.Slice0DataSet;

public class DataSetOps {
    public static DataSet slice0(DataSet ds, int index) {
        return new Slice0DataSet(ds, index);
    }

    public static DataSet slice1(final DataSet ds, final int index) {
        if (ds.rank() > 2) {
            throw new IllegalArgumentException("rank limit > 2");
        }
        return new DataSet(){

            public int rank() {
                return ds.rank() - 1;
            }

            public double value(int i) {
                return ds.value(i, index);
            }

            public double value(int i0, int i1) {
                return ds.value(i0, index, i1);
            }

            public double value(int i0, int i1, int i2) {
                throw new IllegalArgumentException("rank limit");
            }

            public Object property(String name) {
                return ds.property(name);
            }

            public Object property(String name, int i) {
                throw new IllegalArgumentException("rank limit");
            }

            public Object property(String name, int i0, int i1) {
                throw new IllegalArgumentException("rank limit");
            }

            public int length() {
                return ds.length();
            }

            public int length(int i) {
                throw new IllegalArgumentException("rank limit");
            }

            public int length(int i, int j) {
                throw new IllegalArgumentException("rank limit");
            }

            public String toString() {
                return DataSetUtil.toString(this);
            }
        };
    }

    public static DataSet leafTrim(final DataSet ds, final int start, final int end) {
        if (ds.rank() > 3) {
            throw new IllegalArgumentException("rank limit > 3");
        }
        return new DataSet(){

            public int rank() {
                return ds.rank();
            }

            public double value(int i) {
                return ds.value(i + start);
            }

            public double value(int i0, int i1) {
                return ds.value(i0, i1 + start);
            }

            public double value(int i0, int i1, int i2) {
                return ds.value(i0, i1, i2 + start);
            }

            public Object property(String name) {
                String depNName = "DEPEND_" + (ds.rank() - 1);
                if (name.equals(depNName)) {
                    DataSet depN = (DataSet)ds.property(depNName);
                    if (depN != null) {
                        depN = DataSetOps.leafTrim(depN, start, end);
                    }
                    return depN;
                }
                return ds.property(name);
            }

            public Object property(String name, int i) {
                return ds.property(name, i + start);
            }

            public Object property(String name, int i0, int i1) {
                return ds.property(name, i0, i1 + start);
            }

            public int length() {
                return ds.rank() == 1 ? end - start : ds.length();
            }

            public int length(int i) {
                return ds.rank() == 2 ? end - start : ds.length();
            }

            public int length(int i, int j) {
                return ds.rank() == 3 ? end - start : ds.length();
            }

            public String toString() {
                return DataSetUtil.toString(this);
            }
        };
    }

    public static String toString(DataSet ds) {
        return DataSetUtil.toString(ds);
    }

    public static DataSet sort(final DataSet ds) {
        if (ds.rank() > 1) {
            throw new IllegalArgumentException();
        }
        Integer[] indeces = new Integer[ds.length()];
        int i0 = 0;
        Units u = (Units)ds.property("UNITS");
        for (int i = 0; i < ds.length(); ++i) {
            if (u != null && u.isFill(ds.value(i))) continue;
            indeces[i0] = new Integer(i);
            ++i0;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                return Double.compare(ds.value(i1), ds.value(i2));
            }
        };
        Arrays.sort(indeces, 0, i0, c);
        final int[] data = new int[i0];
        for (int i = 0; i < i0; ++i) {
            data[i] = indeces[i];
        }
        return new IndexGenDataSet(i0){

            public double value(int i) {
                return data[i];
            }
        };
    }

    public static DataSet histogram(DataSet ds, double min, double max, double binsize) {
        int n = (int)Math.ceil((max - min) / binsize);
        DataSet tags = DataSetUtil.tagGenDataSet(n, min, binsize);
        Units u = (Units)ds.property("UNITS");
        final int[] hits = new int[n];
        for (int i = 0; i < ds.length(); ++i) {
            int ibin;
            if (u != null && u.isFill(ds.value(i)) || (ibin = (int)((ds.value(i) - min) / binsize)) < 0 || ibin >= n) continue;
            int n2 = ibin;
            hits[n2] = hits[n2] + 1;
        }
        IndexGenDataSet result = new IndexGenDataSet(n){

            public double value(int i) {
                return hits[i];
            }
        };
        result.putProperty("DEPEND_0", tags);
        return result;
    }
}

