/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.MutablePropertyDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetUtil {
    public static DataSet indexGenDataSet(int n) {
        return new IndexGenDataSet(n);
    }

    public static DataSet tagGenDataSet(int n, final double start, final double cadence) {
        return new IndexGenDataSet(n){

            public double value(int i) {
                return (double)i * cadence + start;
            }
        };
    }

    public static boolean isMonotonic(DataSet ds) {
        if (ds.rank() != 1) {
            return false;
        }
        int i = 0;
        Units u = (Units)ds.property("UNITS");
        if (ds.length() == 0) {
            return false;
        }
        double last = ds.value(i);
        if (u != null && u.isFill(last)) {
            return false;
        }
        for (i = 1; i < ds.length(); ++i) {
            double d = ds.value(i);
            if (d <= last || u != null && u.isFill(d)) {
                return false;
            }
            last = d;
        }
        return true;
    }

    public static int binarySearch(DataSet ds, double key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = ds.value(mid);
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int closest(DataSet ds, double d, int guess) {
        int result = DataSetUtil.binarySearch(ds, d, 0, ds.length() - 1);
        if (result == -1) {
            result = 0;
        } else if (result < 0) {
            double x1;
            double x0;
            double x;
            result = (result ^= 0xFFFFFFFF) >= ds.length() - 1 ? ds.length() - 1 : (((x = d) - (x0 = ds.value(result - 1))) / ((x1 = ds.value(result)) - x0) < 0.5 ? result - 1 : result);
        }
        return result;
    }

    public static Map<String, Object> getProperties(DataSet ds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("VALID_RANGE", ds.property("VALID_RANGE"));
        result.put("UNITS", ds.property("UNITS"));
        for (int i = 0; i < ds.rank(); ++i) {
            DataSet dep = (DataSet)ds.property("DEPEND_" + i);
            if (dep == null) continue;
            result.put("DEPEND_" + i, dep);
        }
        DataSet plane0 = (DataSet)ds.property("PLANE_0");
        if (plane0 != null) {
            result.put("PLANE_0", plane0);
        }
        return result;
    }

    public static void putProperties(Map<String, Object> properties, MutablePropertyDataSet ds) {
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            ds.putProperty(e.getKey(), e.getValue());
        }
    }

    public static String toString(DataSet ds) {
        String u;
        StringBuffer dimStr = new StringBuffer("" + ds.length());
        if (ds.rank() > 1) {
            dimStr.append("," + ds.length(0) + "*");
        }
        if (ds.rank() > 2) {
            dimStr.append("," + ds.length(0, 0) + "*");
        }
        if ((u = String.valueOf(ds.property("UNITS"))).equals("null") || u == "") {
            u = "dimensionless";
        }
        return "dataSet[" + dimStr.toString() + "] (" + u + ")";
    }

    public static double guessCadence(DataSet xds) {
        double cadence = Double.MAX_VALUE;
        double cadenceS = Double.MAX_VALUE;
        int cadenceN = 1;
        double x0 = 0.0;
        for (int i = 0; i < xds.length(); ++i) {
            double cadenceAvg = cadenceS / (double)cadenceN;
            cadence = xds.value(i) - x0;
            if (cadence < 0.5 * cadenceAvg) {
                cadenceS = cadence;
                cadenceN = 1;
            } else if (cadence < 1.5 * cadenceAvg) {
                cadenceS += cadence;
                ++cadenceN;
            }
            x0 = xds.value(i);
        }
        return cadenceS / (double)cadenceN;
    }
}

