/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.WritableDataSet;

public final class FDataSet
extends AbstractDataSet
implements WritableDataSet {
    float[] back;
    int rank;
    int len0;
    int len1;
    int len2;
    public static final String version = "20070529";

    public static FDataSet createRank1(int len0) {
        return new FDataSet(1, len0, 1, 1);
    }

    public static FDataSet createRank2(int len0, int len1) {
        return new FDataSet(2, len0, len1, 1);
    }

    public static FDataSet createRank3(int len0, int len1, int len2) {
        return new FDataSet(3, len0, len1, len2);
    }

    private FDataSet(int rank, int len0, int len1, int len2) {
        this(rank, len0, len1, len2, new float[len0 * len1 * len2]);
    }

    private FDataSet(int rank, int len0, int len1, int len2, float[] back) {
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.len0;
    }

    public int length(int i) {
        return this.len1;
    }

    public int length(int i0, int i1) {
        return this.len2;
    }

    public double value(int i0) {
        return this.back[i0];
    }

    public double value(int i0, int i1) {
        return this.back[i0 * this.len1 + i1];
    }

    public double value(int i0, int i1, int i2) {
        return this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
    }

    public void putValue(int i0, double value) {
        this.back[i0] = (float)value;
    }

    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = (float)value;
    }

    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = (float)value;
    }

    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }

    private static Map copyProperties(DataSet ds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("VALID_RANGE", ds.property("VALID_RANGE"));
        result.put("UNITS", ds.property("UNITS"));
        for (int i = 0; i < ds.rank(); ++i) {
            DataSet dep = (DataSet)ds.property("DEPEND_" + i);
            if (dep == null) continue;
            result.put("DEPEND_" + i, FDataSet.copy(dep));
        }
        DataSet plane0 = (DataSet)ds.property("PLANE_0");
        if (plane0 != null) {
            result.put("PLANE_0", FDataSet.copy(plane0));
        }
        return result;
    }

    private static FDataSet ddcopy(FDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2;
        float[] newback = new float[dsLength];
        System.arraycopy(ds.back, 0, newback, 0, dsLength);
        FDataSet result = new FDataSet(ds.rank, ds.len0, ds.len1, ds.len2, newback);
        result.properties.putAll(FDataSet.copyProperties(ds));
        return result;
    }

    public static FDataSet copy(DataSet ds) {
        FDataSet result;
        if (ds instanceof FDataSet) {
            return FDataSet.ddcopy((FDataSet)ds);
        }
        int rank = ds.rank();
        switch (rank) {
            case 1: {
                result = FDataSet.createRank1(ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                result = FDataSet.createRank2(ds.length(), ds.length(0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                result = FDataSet.createRank3(ds.length(), ds.length(0), ds.length(0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(FDataSet.copyProperties(ds));
        return result;
    }

    public static FDataSet wrap(float[] back) {
        return new FDataSet(1, back.length, 1, 1, back);
    }

    public static FDataSet wrap(float[] back, int nx, int ny) {
        return new FDataSet(2, nx, ny, 1, back);
    }

    private void joinProperties(FDataSet ds) {
        HashMap<String, FDataSet> result = new HashMap<String, FDataSet>();
        for (int i = 0; i < ds.rank(); ++i) {
            DataSet dep1 = (DataSet)ds.property("DEPEND_" + i);
            if (dep1 == null) continue;
            DataSet dep0 = (DataSet)this.property("DEPEND_" + i);
            FDataSet djoin = FDataSet.copy(dep0);
            FDataSet ddep1 = dep1 instanceof FDataSet ? (FDataSet)dep1 : FDataSet.copy(dep1);
            djoin.join(ddep1);
            result.put("DEPEND_" + i, djoin);
        }
        DataSet dep1 = (DataSet)ds.property("PLANE_0");
        if (dep1 != null) {
            DataSet dep0 = (DataSet)this.property("PLANE_0");
            FDataSet djoin = FDataSet.copy(dep0);
            FDataSet dd1 = dep1 instanceof FDataSet ? (FDataSet)dep1 : FDataSet.copy(dep1);
            djoin.join(dd1);
            result.put("PLANE_0", djoin);
        }
        this.properties.putAll(result);
    }

    public void join(FDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2;
        int dsLength = ds.len0 * ds.len1 * ds.len2;
        float[] newback = new float[myLength + dsLength];
        System.arraycopy(this.back, 0, newback, 0, myLength);
        System.arraycopy(ds.back, 0, newback, myLength, dsLength);
        this.len0 += ds.len0;
        this.back = newback;
        this.joinProperties(ds);
    }
}

