/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.WritableDataSet;

public final class IDataSet
extends AbstractDataSet
implements WritableDataSet {
    int[] back;
    int rank;
    int len0;
    int len1;
    int len2;
    public static final String version = "20070529";

    public static IDataSet createRank1(int len0) {
        return new IDataSet(1, len0, 1, 1);
    }

    public static IDataSet createRank2(int len0, int len1) {
        return new IDataSet(2, len0, len1, 1);
    }

    public static IDataSet createRank3(int len0, int len1, int len2) {
        return new IDataSet(3, len0, len1, len2);
    }

    private IDataSet(int rank, int len0, int len1, int len2) {
        this(rank, len0, len1, len2, new int[len0 * len1 * len2]);
    }

    private IDataSet(int rank, int len0, int len1, int len2, int[] back) {
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.len0;
    }

    public int length(int i) {
        return this.len1;
    }

    public int length(int i0, int i1) {
        return this.len2;
    }

    public double value(int i0) {
        return this.back[i0];
    }

    public double value(int i0, int i1) {
        return this.back[i0 * this.len1 + i1];
    }

    public double value(int i0, int i1, int i2) {
        return this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
    }

    public void putValue(int i0, double value) {
        this.back[i0] = (int)value;
    }

    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = (int)value;
    }

    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = (int)value;
    }

    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }

    private static Map copyProperties(DataSet ds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("VALID_RANGE", ds.property("VALID_RANGE"));
        result.put("UNITS", ds.property("UNITS"));
        for (int i = 0; i < ds.rank(); ++i) {
            DataSet dep = (DataSet)ds.property("DEPEND_" + i);
            if (dep == null) continue;
            result.put("DEPEND_" + i, IDataSet.copy(dep));
        }
        DataSet plane0 = (DataSet)ds.property("PLANE_0");
        if (plane0 != null) {
            result.put("PLANE_0", IDataSet.copy(plane0));
        }
        return result;
    }

    private static IDataSet ddcopy(IDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2;
        int[] newback = new int[dsLength];
        System.arraycopy(ds.back, 0, newback, 0, dsLength);
        IDataSet result = new IDataSet(ds.rank, ds.len0, ds.len1, ds.len2, newback);
        result.properties.putAll(IDataSet.copyProperties(ds));
        return result;
    }

    public static IDataSet copy(DataSet ds) {
        IDataSet result;
        if (ds instanceof IDataSet) {
            return IDataSet.ddcopy((IDataSet)ds);
        }
        int rank = ds.rank();
        switch (rank) {
            case 1: {
                result = IDataSet.createRank1(ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                result = IDataSet.createRank2(ds.length(), ds.length(0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                result = IDataSet.createRank3(ds.length(), ds.length(0), ds.length(0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(IDataSet.copyProperties(ds));
        return result;
    }

    public static IDataSet wrap(int[] back) {
        return new IDataSet(1, back.length, 1, 1, back);
    }

    public static IDataSet wrap(int[] back, int nx, int ny) {
        return new IDataSet(2, nx, ny, 1, back);
    }

    private void joinProperties(IDataSet ds) {
        HashMap<String, IDataSet> result = new HashMap<String, IDataSet>();
        for (int i = 0; i < ds.rank(); ++i) {
            DataSet dep1 = (DataSet)ds.property("DEPEND_" + i);
            if (dep1 == null) continue;
            DataSet dep0 = (DataSet)this.property("DEPEND_" + i);
            IDataSet djoin = IDataSet.copy(dep0);
            IDataSet ddep1 = dep1 instanceof IDataSet ? (IDataSet)dep1 : IDataSet.copy(dep1);
            djoin.join(ddep1);
            result.put("DEPEND_" + i, djoin);
        }
        DataSet dep1 = (DataSet)ds.property("PLANE_0");
        if (dep1 != null) {
            DataSet dep0 = (DataSet)this.property("PLANE_0");
            IDataSet djoin = IDataSet.copy(dep0);
            IDataSet dd1 = dep1 instanceof IDataSet ? (IDataSet)dep1 : IDataSet.copy(dep1);
            djoin.join(dd1);
            result.put("PLANE_0", djoin);
        }
        this.properties.putAll(result);
    }

    public void join(IDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2;
        int dsLength = ds.len0 * ds.len1 * ds.len2;
        int[] newback = new int[myLength + dsLength];
        System.arraycopy(this.back, 0, newback, 0, myLength);
        System.arraycopy(ds.back, 0, newback, myLength, dsLength);
        this.len0 += ds.len0;
        this.back = newback;
        this.joinProperties(ds);
    }
}

