/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.DatumVectorAdapter;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.VectorDataSetAdapter;

public class TableDataSetAdapter
implements TableDataSet {
    Units xunits;
    Units yunits;
    Units zunits;
    DataSet x;
    DataSet y;
    DataSet z;
    HashMap properties = new HashMap();

    public static TableDataSet create(DataSet z) {
        DataSet yds;
        DataSet xds = (DataSet)z.property("DEPEND_0");
        if (xds == null) {
            xds = new IndexGenDataSet(z.length());
        }
        if ((yds = (DataSet)z.property("DEPEND_1")) == null) {
            yds = new IndexGenDataSet(z.length(0));
        }
        return new TableDataSetAdapter(z, xds, yds);
    }

    public TableDataSetAdapter(DataSet z, DataSet x, DataSet y) {
        Double cadence;
        this.xunits = (Units)x.property("UNITS");
        this.yunits = (Units)y.property("UNITS");
        this.zunits = (Units)z.property("UNITS");
        if (this.xunits == null) {
            this.xunits = Units.dimensionless;
        }
        if (this.yunits == null) {
            this.yunits = Units.dimensionless;
        }
        if (this.zunits == null) {
            this.zunits = Units.dimensionless;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        Boolean xMono = (Boolean)x.property("MONOTONIC");
        if (xMono != null && xMono.booleanValue()) {
            this.properties.put("xMonotonic", Boolean.TRUE);
        }
        if ((cadence = (Double)x.property("CADENCE")) != null) {
            this.properties.put("xTagWidth", this.xunits.getOffsetUnits().createDatum(cadence.doubleValue()));
        }
        if ((cadence = (Double)y.property("CADENCE")) != null) {
            this.properties.put("yTagWidth", this.xunits.getOffsetUnits().createDatum(cadence.doubleValue()));
        }
    }

    public Units getZUnits() {
        return this.zunits;
    }

    public Datum getDatum(int i, int j) {
        return this.zunits.createDatum(this.z.value(i, j));
    }

    public double getDouble(int i, int j, Units units) {
        return this.zunits.convertDoubleTo(units, this.z.value(i, j));
    }

    private void notImplemented() {
        throw new IllegalArgumentException("not implemented");
    }

    public double[] getDoubleScan(int i, Units units) {
        double[] zz = new double[this.getYLength(this.tableOfIndex(i))];
        for (int j = 0; j < zz.length; ++j) {
            zz[j] = this.getDouble(i, j, this.getYUnits());
        }
        return zz;
    }

    public DatumVector getScan(int i) {
        double[] zz = this.getDoubleScan(i, this.getZUnits());
        return DatumVector.newDatumVector((double[])zz, (Units)this.getZUnits());
    }

    public int getInt(int i, int j, Units units) {
        return (int)this.getDouble(i, j, units);
    }

    public DatumVector getYTags(int table) {
        return DatumVectorAdapter.toDatumVector(this.y);
    }

    public Datum getYTagDatum(int table, int j) {
        if (table > 0) {
            throw new IllegalArgumentException("table>0");
        }
        return this.yunits.createDatum(this.y.value(j));
    }

    public double getYTagDouble(int table, int j, Units units) {
        if (table > 0) {
            throw new IllegalArgumentException("table>0");
        }
        return this.yunits.convertDoubleTo(units, this.y.value(j));
    }

    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    public int getYLength(int table) {
        return this.y.length();
    }

    public int tableStart(int table) {
        return 0;
    }

    public int tableEnd(int table) {
        return this.getXLength();
    }

    public int tableCount() {
        return 1;
    }

    public int tableOfIndex(int i) {
        return 0;
    }

    public VectorDataSet getXSlice(int i) {
        return new VectorDataSetAdapter(DataSetOps.slice0(this.z, i), this.y);
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new VectorDataSetAdapter(DataSetOps.slice1(this.z, j), this.x);
    }

    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        return result != null ? result : this.z.property(name);
    }

    public Map getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>(DataSetUtil.getProperties(this.z));
        m.putAll(this.properties);
        return m;
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public Datum getXTagDatum(int i) {
        return this.xunits.createDatum(this.x.value(i));
    }

    public double getXTagDouble(int i, Units units) {
        return this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    public int getXTagInt(int i, Units units) {
        return (int)this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    public int getXLength() {
        return this.x.length();
    }

    public edu.uiowa.physics.pw.das.dataset.DataSet getPlanarView(String planeID) {
        return planeID.equals("") ? this : null;
    }

    public String[] getPlaneIds() {
        return new String[0];
    }

    public String toString() {
        return DataSetUtil.toString(this.z);
    }
}

