/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexGenDataSet;

public class VectorDataSetAdapter
implements VectorDataSet {
    Units xunits;
    Units yunits;
    Units zunits;
    DataSet x;
    DataSet y;
    DataSet plane0;
    HashMap properties = new HashMap();

    public static VectorDataSet create(DataSet y) {
        DataSet xds = (DataSet)y.property("DEPEND_0");
        if (xds == null) {
            xds = new IndexGenDataSet(y.length());
        }
        return new VectorDataSetAdapter(y, xds);
    }

    public VectorDataSetAdapter(DataSet y, DataSet x) {
        Double cadence;
        if (y.rank() != 1) {
            throw new IllegalArgumentException("y (rank=" + y.rank() + ") is not rank 1");
        }
        if (x.rank() != 1) {
            throw new IllegalArgumentException("x (rank=" + x.rank() + ") is not rank 1");
        }
        this.xunits = (Units)x.property("UNITS");
        if (this.xunits == null) {
            this.xunits = Units.dimensionless;
        }
        this.yunits = (Units)y.property("UNITS");
        if (this.yunits == null) {
            this.yunits = Units.dimensionless;
        }
        this.x = x;
        this.y = y;
        this.plane0 = (DataSet)y.property("PLANE_0");
        Boolean xMono = (Boolean)x.property("MONOTONIC");
        if (xMono != null && xMono.booleanValue()) {
            this.properties.put("xMonotonic", Boolean.TRUE);
        }
        if ((cadence = (Double)x.property("CADENCE")) != null) {
            this.properties.put("xTagWidth", this.xunits.getOffsetUnits().createDatum(cadence.doubleValue()));
        }
    }

    public Datum getDatum(int i) {
        return this.yunits.createDatum(this.y.value(i));
    }

    public double getDouble(int i, Units units) {
        return this.yunits.convertDoubleTo(units, this.y.value(i));
    }

    public int getInt(int i, Units units) {
        return (int)this.yunits.convertDoubleTo(units, this.y.value(i));
    }

    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        return result != null ? result : this.y.property(name);
    }

    public Map getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>(DataSetUtil.getProperties(this.y));
        m.putAll(this.properties);
        return m;
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public Datum getXTagDatum(int i) {
        return this.xunits.createDatum(this.x.value(i));
    }

    public double getXTagDouble(int i, Units units) {
        return this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    public int getXTagInt(int i, Units units) {
        return (int)this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    public int getXLength() {
        return this.x.length();
    }

    public edu.uiowa.physics.pw.das.dataset.DataSet getPlanarView(String planeID) {
        if (planeID.equals("")) {
            return this;
        }
        if (planeID.equals("plane0") && this.plane0 != null) {
            return new VectorDataSetAdapter(this.plane0, this.x);
        }
        return null;
    }

    public String[] getPlaneIds() {
        if (this.plane0 != null) {
            return new String[]{"plane0"};
        }
        return new String[0];
    }

    public String toString() {
        return DataSetUtil.toString(this.y);
    }
}

