/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.NullProgressMonitor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.virbo.dataset.DataSet;
import org.virbo.dsutil.DataSetBuilder;

public class AsciiParser {
    Pattern propertyPattern;
    String commentRegex;
    String[] fieldNames;
    Units[] units;
    static final String numberPart = "[\\d\\.eE\\+\\-]+";
    static final String decimalRegex = "[\\d\\.eE\\+\\-]+";
    int skipLines;
    int recordCountLimit;
    int fieldCount;
    public static final Pattern NAME_COLON_VALUE_PATTERN;
    public static final Pattern NAME_EQUAL_VALUE_PATTERN;
    public static final String PROPERTY_FIELD_NAMES = "fieldNames";
    private static final String SPACES;
    private static final String DASHES;
    public static final String PROPERTY_FILE_HEADER = "file_header";
    public static final FieldParser DOUBLE_PARSER;
    public final FieldParser UNITS_PARSER = new FieldParser(){

        public final double parseField(String field, int columnIndex) throws ParseException {
            Units u = AsciiParser.this.units[columnIndex];
            return u.parse(field).doubleValue(u);
        }
    };
    private boolean keepFileHeader;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RecordParser recordParser;

    private AsciiParser(String[] fieldNames) {
        this.fieldCount = fieldNames.length;
        this.fieldNames = fieldNames;
        this.units = new Units[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            this.units[i] = Units.dimensionless;
        }
        StringBuffer regexBuf = new StringBuffer();
        regexBuf.append("\\s*");
        for (int i = 0; i < this.fieldCount - 1; ++i) {
            regexBuf.append("([\\d\\.eE\\+\\-]+)[\\s+,+]\\s*");
        }
        regexBuf.append("([\\d\\.eE\\+\\-]+)\\s*");
        this.recordParser = new RegexParser(regexBuf.toString());
    }

    public static String[] guessFieldNames(String filename) throws FileNotFoundException, IOException {
        int fieldCount = AsciiParser.guessFieldCount(filename);
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return fieldNames;
    }

    public static int guessFieldCount(String filename) throws FileNotFoundException, IOException {
        String line;
        int maxFieldCount = 10;
        int[] recCount = new int[10];
        StringBuffer regexBuf = new StringBuffer();
        regexBuf.append("\\s*([\\d\\.eE\\+\\-]+)");
        for (int i = 1; i < 10; ++i) {
            regexBuf.append("([\\s+,+]\\s*([\\d\\.eE\\+\\-]+))?");
        }
        regexBuf.append("\\s*");
        Pattern pat = Pattern.compile(regexBuf.toString());
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        block1: while ((line = ((BufferedReader)reader).readLine()) != null) {
            Matcher m = pat.matcher(line);
            if (!m.matches()) continue;
            for (int j = 1; j < m.groupCount(); j += 2) {
                if (m.group(j) != null) continue;
                int n = (j - 1) / 2;
                recCount[n] = recCount[n] + 1;
                continue block1;
            }
        }
        int max = 0;
        int imax = 0;
        for (int j = 1; j < 10; ++j) {
            if (recCount[j] <= max) continue;
            imax = j;
            max = recCount[j];
        }
        return imax;
    }

    public FixedColumnsParser setFixedColumnsParser(String filename, String delim) throws IOException {
        int i;
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        String line = ((BufferedReader)reader).readLine();
        for (int i2 = 0; i2 < this.skipLines; ++i2) {
            line = ((BufferedReader)reader).readLine();
        }
        reader.close();
        int col = 0;
        String[] ss = line.split(delim);
        int[] columnOffsets = new int[ss.length];
        int[] columnWidths = new int[ss.length - 1];
        FieldParser[] fieldParsers = new FieldParser[ss.length - 1];
        boolean rightJustified = false;
        if (ss[0].trim().length() == 0) {
            rightJustified = true;
            for (i = 0; i < ss.length - 1; ++i) {
                ss[i] = ss[i + 1];
            }
        }
        columnOffsets[0] = 0;
        if (rightJustified) {
            for (i = 1; i < ss.length; ++i) {
                col = line.indexOf(ss[i - 1], columnOffsets[i - 1]);
                columnOffsets[i] = col + ss[i - 1].length();
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        } else {
            for (i = 1; i < ss.length; ++i) {
                columnOffsets[i] = col = line.indexOf(ss[i], col + ss[i - 1].length());
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        }
        for (i = 1; i < ss.length; ++i) {
            fieldParsers[i - 1] = DOUBLE_PARSER;
        }
        int[] co = new int[columnWidths.length];
        for (int i3 = 0; i3 < columnWidths.length; ++i3) {
            co[i3] = columnOffsets[i3];
        }
        FixedColumnsParser p = new FixedColumnsParser(co, columnWidths, fieldParsers);
        this.recordParser = p;
        return p;
    }

    public static AsciiParser newParser(int fieldCount) {
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return new AsciiParser(fieldNames);
    }

    public static AsciiParser newParser(String[] fieldNames) {
        return new AsciiParser(fieldNames);
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public void setRecordCountLimit(int recordCountLimit) {
        this.recordCountLimit = recordCountLimit;
    }

    public void setPropertyPattern(Pattern propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    private DataSet readStream(InputStream in, DasProgressMonitor mon) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int iline = 0;
        int irec = 0;
        mon.started();
        DataSetBuilder builder = new DataSetBuilder(2, 100, this.recordParser.fieldCount(), 1);
        long bytesRead = 0L;
        StringBuffer headerBuffer = new StringBuffer();
        while ((line = reader.readLine()) != null && !mon.isCancelled()) {
            ++iline;
            mon.setTaskProgress(bytesRead += (long)(line.length() + 1));
            try {
                Matcher m;
                if (iline < this.skipLines) {
                    if (!this.keepFileHeader) continue;
                    headerBuffer.append(line);
                    continue;
                }
                if (this.propertyPattern != null && (m = this.propertyPattern.matcher(line)).matches()) {
                    builder.putProperty(m.group(1).trim(), m.group(2).trim());
                    continue;
                }
                if (!this.recordParser.tryParseRecord(line, irec, builder)) continue;
                ++irec;
                builder.nextRecord();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        mon.finished();
        builder.putProperty(PROPERTY_FILE_HEADER, headerBuffer.toString());
        return builder.getDataSet();
    }

    public DataSet readFile(String filename, DasProgressMonitor mon) throws IOException {
        long size = new File(filename).length();
        mon.setTaskSize(size);
        return this.readStream(new FileInputStream(filename), mon);
    }

    public static void main(String[] args) throws Exception {
        String file = "L:/ct/virbo/autoplot/data/2490lintest90005.dat";
        AsciiParser parser = AsciiParser.newParser(5);
        parser.setPropertyPattern(Pattern.compile("\\s*(.+)\\s*\\:\\s*(.+)\\s*"));
        long t0 = System.currentTimeMillis();
        DataSet ds = parser.readFile(file, (DasProgressMonitor)new NullProgressMonitor());
        System.out.println("" + (System.currentTimeMillis() - t0));
        System.out.println(ds.property("Frequency"));
        System.out.flush();
    }

    public AsciiParser() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isKeepFileHeader() {
        return this.keepFileHeader;
    }

    public void setKeepFileHeader(boolean keepHeader) {
        boolean oldKeepHeader = this.keepFileHeader;
        this.keepFileHeader = keepHeader;
        this.propertyChangeSupport.firePropertyChange("keepHeader", new Boolean(oldKeepHeader), new Boolean(keepHeader));
    }

    public RecordParser getRecordParser() {
        return this.recordParser;
    }

    public void setRecordParser(RecordParser recordParser) {
        RecordParser oldRecordParser = this.recordParser;
        this.recordParser = recordParser;
        this.propertyChangeSupport.firePropertyChange("recordParser", oldRecordParser, recordParser);
    }

    public Units getUnits(int index) {
        return this.units[index];
    }

    public void setUnits(int index, Units units) {
        this.units[index] = units;
        this.propertyChangeSupport.firePropertyChange("units", null, null);
    }

    static {
        int i;
        NAME_COLON_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\:\\s*(.+)\\s*");
        NAME_EQUAL_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\=\\s*(.+)\\s*");
        StringBuffer buf = new StringBuffer(1024);
        for (i = 0; i < 1024; ++i) {
            buf.append(" ");
        }
        SPACES = buf.toString();
        buf = new StringBuffer(1024);
        for (i = 0; i < 1024; ++i) {
            buf.append("-");
        }
        DASHES = buf.toString();
        DOUBLE_PARSER = new FieldParser(){

            public final double parseField(String field, int columnIndex) {
                return Double.parseDouble(field);
            }
        };
    }

    public static final class FixedColumnsParser
    implements RecordParser {
        int[] columnOffsets;
        int[] columnWidths;
        FieldParser[] parsers;
        private int fieldCount;

        public FixedColumnsParser(int[] columnOffsets, int[] columnWidths, FieldParser[] parsers) {
            this.columnOffsets = columnOffsets;
            this.columnWidths = columnWidths;
            this.parsers = parsers;
            this.fieldCount = columnOffsets.length;
        }

        public int fieldCount() {
            return this.fieldCount;
        }

        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            boolean[] fails = new boolean[this.fieldCount];
            int failCount = 0;
            for (int i = 0; i < this.fieldCount; ++i) {
                try {
                    if (this.parsers[i] == null) {
                        System.err.println("here: " + i + "  " + this.fieldCount);
                    }
                    double d = this.parsers[i].parseField(line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]), i);
                    builder.putValue(irec, i, d);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ++failCount;
                    fails[i] = true;
                    continue;
                }
                catch (ParseException ex) {
                    ++failCount;
                    fails[i] = true;
                }
            }
            if (failCount > 0) {
                System.err.println("error(s) parsing record number " + irec + ": ");
                System.err.println(line);
                char[] lineMarker = new char[this.columnOffsets[this.fieldCount - 1] + this.columnWidths[this.fieldCount - 1]];
                for (int i = 0; i < this.fieldCount; ++i) {
                    if (!fails[i]) continue;
                    for (int j = 0; j < this.columnWidths[i]; ++j) {
                        lineMarker[j + this.columnOffsets[i]] = 45;
                    }
                }
                System.err.println(new String(lineMarker));
            }
            return true;
        }
    }

    public final class RegexParser
    implements RecordParser {
        Pattern recordPattern;
        int fieldCount;

        public RegexParser(String regex) {
            this.recordPattern = Pattern.compile(regex);
            this.fieldCount = this.fieldCount;
        }

        public int fieldCount() {
            return this.fieldCount;
        }

        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            Matcher m;
            if (this.recordPattern != null && (m = this.recordPattern.matcher(line)).matches()) {
                try {
                    int i;
                    boolean allInvalid = true;
                    for (i = 0; i < this.fieldCount; ++i) {
                        try {
                            double d = Double.parseDouble(m.group(i + 1));
                            allInvalid = false;
                            continue;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (!allInvalid) {
                        for (i = 0; i < this.fieldCount; ++i) {
                            builder.putValue(irec, i, AsciiParser.this.units[i].parse(m.group(i + 1)).doubleValue(AsciiParser.this.units[i]));
                        }
                        return true;
                    }
                    return false;
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            return false;
        }
    }

    public static interface FieldParser {
        public double parseField(String var1, int var2) throws ParseException;
    }

    public static interface RecordParser {
        public boolean tryParseRecord(String var1, int var2, DataSetBuilder var3);

        public int fieldCount();
    }
}

