/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Arrays;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;

public class BinAverage {
    private BinAverage() {
    }

    public static DDataSet rebin(DataSet ds, DataSet newTags0) {
        int i;
        DataSet dstags = (DataSet)ds.property("DEPEND_0");
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        double fill = u.getFillDouble();
        DDataSet result = DDataSet.createRank1(newTags0.length());
        DDataSet weights = DDataSet.createRank1(newTags0.length());
        int ibin = -1;
        for (i = 0; i < ds.length(); ++i) {
            ibin = DataSetUtil.closest(newTags0, dstags.value(i), ibin);
            double d = ds.value(i);
            if (!u.isValid(d)) continue;
            double s = result.value(ibin);
            result.putValue(ibin, s + d);
            double w = weights.value(ibin);
            weights.putValue(ibin, w + 1.0);
        }
        for (i = 0; i < result.length(); ++i) {
            if (weights.value(i) > 0.0) {
                result.putValue(i, result.value(i) / weights.value(i));
                continue;
            }
            result.putValue(i, fill);
        }
        result.putProperty("DEPEND_0", newTags0);
        return result;
    }

    public static DDataSet rebin(DataSet ds, DataSet newTags0, DataSet newTags1) {
        int i;
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("ds must be rank2");
        }
        DataSet dstags0 = (DataSet)ds.property("DEPEND_0");
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        double fill = u.getFillDouble();
        DDataSet result = DDataSet.createRank2(newTags0.length(), newTags1.length());
        DDataSet weights = DDataSet.createRank2(newTags0.length(), newTags1.length());
        DataSet ibin1CacheDs = null;
        int[] ibins1 = null;
        int ibin0 = -1;
        for (i = 0; i < ds.length(); ++i) {
            int j;
            ibin0 = DataSetUtil.closest(newTags0, dstags0.value(i), ibin0);
            DataSet dstags1 = (DataSet)ds.property("DEPEND_1", i);
            if (dstags1 != ibin1CacheDs) {
                ibins1 = new int[dstags1.length()];
                Arrays.fill(ibins1, -1);
                for (j = 0; j < dstags1.length(); ++j) {
                    ibins1[j] = DataSetUtil.closest(newTags1, dstags1.value(j), ibins1[j]);
                }
                ibin1CacheDs = dstags1;
            }
            for (j = 0; j < dstags1.length(); ++j) {
                int ibin1 = ibins1[j];
                double d = ds.value(i, j);
                if (!u.isValid(d)) continue;
                double s = result.value(ibin0, ibin1);
                result.putValue(ibin0, ibin1, s + d);
                double w = weights.value(ibin0, ibin1);
                weights.putValue(ibin0, ibin1, w + 1.0);
            }
        }
        for (i = 0; i < result.length(); ++i) {
            for (int j = 0; j < result.length(i); ++j) {
                if (weights.value(i, j) > 0.0) {
                    result.putValue(i, j, result.value(i, j) / weights.value(i, j));
                    continue;
                }
                result.putValue(i, j, fill);
            }
        }
        result.putProperty("DEPEND_0", newTags0);
        result.putProperty("DEPEND_1", newTags1);
        return result;
    }

    public static DDataSet boxcar(DataSet ds, int size) {
        double w;
        double d;
        int i;
        int nn = ds.length();
        int s2 = size / 2;
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        DDataSet sums = DDataSet.createRank1(nn);
        DataSetUtil.putProperties(DataSetUtil.getProperties(ds), sums);
        DDataSet weights = DDataSet.createRank1(nn);
        double runningSum = 0.0;
        double runningWeight = 0.0;
        for (i = 0; i < size; ++i) {
            d = ds.value(i);
            w = u.isValid(d) ? 1.0 : 0.0;
            sums.putValue(i, d);
            weights.putValue(i, w);
            runningSum += d;
            runningWeight += w;
        }
        for (i = s2; i < nn - s2; ++i) {
            sums.putValue(i, runningSum);
            weights.putValue(i, runningWeight);
            double d0 = ds.value(i - s2);
            double w0 = u.isValid(d0) ? 1.0 : 0.0;
            double d2 = ds.value(i - s2 + size);
            double w2 = u.isValid(d2) ? 1.0 : 0.0;
            runningSum += d2 * w2 - d0 * w0;
            runningWeight += w2 - w0;
        }
        for (i = nn - s2; i < size; ++i) {
            d = ds.value(i);
            w = u.isValid(d) ? 1.0 : 0.0;
            sums.putValue(i, d);
            weights.putValue(i, w);
        }
        DDataSet result = sums;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (weights.value(i2) > 0.0) {
                result.putValue(i2, result.value(i2) / weights.value(i2));
                continue;
            }
            result.putValue(i2, u.getFillDouble());
        }
        result.putProperty("WEIGHTS", weights);
        return result;
    }
}

