/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import java.util.StringTokenizer;

public class FtpListResult {
    public static final int DIRECTORY = 1;
    public static final int FILE = 2;
    public static final int LINK = 3;
    public static final int BLK_DEV = 4;
    public static final int CHAR_DEV = 5;
    public static final int OTHERS = 6;
    private int[] type;
    private long[] size;
    private String[] permission;
    private String[] owner;
    private String[] group;
    private String[] name;
    private String[] date;
    private int index = -1;
    private final boolean DEBUG = false;

    public int getFtBlkDev() {
        return 4;
    }

    public int getFtCharDev() {
        return 5;
    }

    public int getFtFile() {
        return 2;
    }

    public int getFtDir() {
        return 1;
    }

    public int getFtLink() {
        return 3;
    }

    public String getDate() {
        return this.date[this.index];
    }

    public String getGroup() {
        return this.group[this.index];
    }

    public String getName() {
        return this.name[this.index];
    }

    public String getOwner() {
        return this.owner[this.index];
    }

    public String getPermission() {
        return this.permission[this.index];
    }

    public long getSize() {
        return this.size[this.index];
    }

    public int getType() {
        return this.type[this.index];
    }

    public boolean ownerReadable() {
        return this.isOwnerReadable();
    }

    public boolean isOwnerReadable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(0) != '-';
    }

    public boolean ownerWritable() {
        return this.isOwnerWritable();
    }

    public boolean isOwnerWritable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(1) != '-';
    }

    public boolean ownerExecutable() {
        return this.isOwnerExecutable();
    }

    public boolean isOwnerExecutable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(2) != '-';
    }

    public boolean groupReadable() {
        return this.isGroupReadable();
    }

    public boolean isGroupReadable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(3) != '-';
    }

    public boolean groupWritable() {
        return this.isGroupWritable();
    }

    public boolean isGroupWritable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(4) != '-';
    }

    public boolean groupExecutable() {
        return this.isGroupExecutable();
    }

    public boolean isGroupExecutable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(5) != '-';
    }

    public boolean globalReadable() {
        return this.isGlobalReadable();
    }

    public boolean isGlobalReadable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(6) != '-';
    }

    public boolean globalWritable() {
        return this.isGlobalWritable();
    }

    public boolean isGlobalWritable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(7) != '-';
    }

    public boolean globalExecutable() {
        return this.isGlobalExecutable();
    }

    public boolean isGlobalExecutable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(8) != '-';
    }

    public boolean next() {
        if (this.name == null || this.index >= this.name.length - 1) {
            return false;
        }
        ++this.index;
        return true;
    }

    protected void parseList(String strlist, String system_type) {
        if (strlist.length() <= 0) {
            return;
        }
        if (system_type.toLowerCase().indexOf("windows") == -1) {
            char first_char = strlist.charAt(0);
            if (first_char != 'd' && first_char != '-' && first_char != 'l' && first_char != 'b' && first_char != 'c') {
                this.parseUnixList(strlist, 1);
            } else {
                this.parseUnixList(strlist, 0);
            }
        } else {
            char first_char = strlist.charAt(0);
            if (first_char != 'd' && first_char != '-' && first_char != 'l' && first_char != 'b' && first_char != 'c') {
                this.parseDosList(strlist);
            } else {
                this.parseUnixList(strlist, 0);
            }
        }
    }

    private void parseUnixList(String strlist, int skip) {
        int num_lines = this.countLine(strlist) - skip;
        this.type = new int[num_lines];
        this.permission = new String[num_lines];
        this.owner = new String[num_lines];
        this.group = new String[num_lines];
        this.size = new long[num_lines];
        this.name = new String[num_lines];
        this.date = new String[num_lines];
        int start = 0;
        int end = 0;
        if (skip == 1) {
            start = strlist.indexOf(10) + 1;
        }
        boolean name_index = false;
        for (int i = 0; i < num_lines; ++i) {
            int cut;
            end = strlist.substring(start).indexOf(10);
            String line = strlist.substring(start, start + end);
            start += end + 1;
            int date_cols = 3;
            StringTokenizer st = new StringTokenizer(line, " ");
            String temp = st.nextToken();
            this.type[i] = this.parseType(temp);
            this.permission[i] = this.parsePermission(temp);
            st.nextToken();
            this.owner[i] = st.nextToken();
            this.group[i] = st.nextToken();
            String skip_col = "";
            if (this.type[i] == 4 || this.type[i] == 5) {
                skip_col = st.nextToken();
            }
            this.date[i] = "";
            try {
                temp = st.nextToken();
                this.size[i] = Long.parseLong(temp);
            }
            catch (NumberFormatException e) {
                try {
                    this.size[i] = Long.parseLong(this.group[i]);
                }
                catch (NumberFormatException e1) {
                    this.size[i] = Long.parseLong(skip_col);
                }
                this.date[i] = temp.concat(" ");
                this.group[i] = "";
                date_cols = 2;
            }
            for (int j = 0; j < date_cols; ++j) {
                if (j > 0) {
                    this.date[i] = this.date[i].concat(" ");
                }
                this.date[i] = this.date[i].concat(st.nextToken());
            }
            this.name[i] = st.nextToken("\n").trim();
            if (this.type[i] != 3 || (cut = this.name[i].lastIndexOf("->")) <= -1) continue;
            this.name[i] = this.name[i].substring(0, cut).trim();
        }
    }

    private void parseDosList(String strlist) {
        int num_lines = this.countLine(strlist);
        this.type = new int[num_lines];
        this.permission = new String[num_lines];
        this.owner = new String[num_lines];
        this.group = new String[num_lines];
        this.size = new long[num_lines];
        this.name = new String[num_lines];
        int start = 0;
        int end = 0;
        boolean name_index = false;
        for (int i = 0; i < num_lines; ++i) {
            end = strlist.substring(start).indexOf(10);
            String line = strlist.substring(start, start + end);
            start += end + 1;
            this.permission[i] = "";
            this.owner[i] = "";
            this.group[i] = "";
            StringTokenizer st = new StringTokenizer(line, " ");
            for (int j = 0; j < 2; ++j) {
                st.nextToken();
            }
            String temp = st.nextToken();
            if (temp.equals("<DIR>")) {
                this.type[i] = 1;
                this.size[i] = 0L;
            } else {
                this.type[i] = 2;
                this.size[i] = Long.parseLong(temp);
            }
            this.name[i] = st.nextToken("\n").trim();
        }
    }

    private int parseType(String str) {
        char c = str.charAt(0);
        int type = 0;
        type = c == 'd' ? 1 : (c == '-' ? 2 : (c == 'l' ? 3 : (c == 'b' ? 4 : (c == 'c' ? 5 : 6))));
        return type;
    }

    private String parsePermission(String str) {
        return str.substring(1, str.length());
    }

    private int countLine(String str) {
        int temp;
        int index = 0;
        int num_of_lines = 0;
        while ((temp = str.substring(index).indexOf("\n")) != -1) {
            ++num_of_lines;
            index += temp + 1;
        }
        if (str.substring(index).length() > 0) {
            ++num_of_lines;
        }
        return num_of_lines;
    }
}

