/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.aggragator;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.SubTaskMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileStorageModel;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import org.virbo.aggragator.AggregatingDataSourceFactory;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSourceFactory;

public class AggregatingDataSource
extends AbstractDataSource {
    private FileStorageModel fsm;
    DataSourceFactory delegateDataSourceFactory;
    private DatumRange viewRange = DatumRangeUtil.parseTimeRangeValid((String)"2006-07-03 to 2006-07-05");
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String params = "";

    public AggregatingDataSource(URL url) throws MalformedURLException, FileSystem.FileSystemOfflineException, IOException, ParseException {
        super(url);
        String surl = url.toString();
        this.delegateDataSourceFactory = AggregatingDataSourceFactory.getDelegateDataSourceFactory(surl);
    }

    public DataSet getDataSet(DasProgressMonitor mon) throws Exception {
        String[] ss = this.getFsm().getNamesFor(this.viewRange);
        DDataSet result = null;
        mon.setTaskSize((long)(ss.length * 10));
        mon.started();
        for (int i = 0; i < ss.length; ++i) {
            String scompUrl = this.getFsm().getFileSystem().getRootURL() + ss[i];
            if (!this.params.equals("")) {
                scompUrl = scompUrl + "?" + this.params;
            }
            URL compUrl = new URL(scompUrl);
            DataSet ds1 = this.delegateDataSourceFactory.getDataSource(compUrl).getDataSet((DasProgressMonitor)SubTaskMonitor.create((DasProgressMonitor)mon, (long)(i * 10), (long)(10 * (i + 1))));
            if (result == null) {
                result = DDataSet.copy((DataSet)ds1);
                continue;
            }
            result.join(DDataSet.copy((DataSet)ds1));
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public DatumRange getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(DatumRange viewRange) {
        DatumRange oldViewRange = this.viewRange;
        this.viewRange = viewRange;
        this.propertyChangeSupport.firePropertyChange("viewRange", oldViewRange, viewRange);
    }

    public FileStorageModel getFsm() {
        return this.fsm;
    }

    public void setFsm(FileStorageModel fsm) {
        this.fsm = fsm;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        String oldParams = this.params;
        this.params = params;
        this.propertyChangeSupport.firePropertyChange("args", oldParams, params);
    }
}

