/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.virbo.ascii.DataSetBuilder;
import org.virbo.dataset.DataSet;

public class AsciiParser {
    Pattern propertyPattern;
    String commentRegex;
    String[] fieldNames;
    Units[] units;
    RecordParser recParser;
    static final String numberPart = "[\\d\\.eE\\+\\-]+";
    static final String decimalRegex = "[\\d\\.eE\\+\\-]+";
    int skipLines;
    int recordCountLimit;
    int fieldCount;
    public static final Pattern NAME_COLON_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\:\\s*(.+)\\s*");
    public static final Pattern NAME_EQUAL_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\=\\s*(.+)\\s*");
    public static final String PROPERTY_FIELD_NAMES = "fieldNames";

    private AsciiParser(String[] fieldNames) {
        this.fieldCount = fieldNames.length;
        this.fieldNames = fieldNames;
        this.units = new Units[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            this.units[i] = Units.dimensionless;
        }
        StringBuffer regexBuf = new StringBuffer();
        regexBuf.append("\\s*");
        for (int i = 0; i < this.fieldCount - 1; ++i) {
            regexBuf.append("([\\d\\.eE\\+\\-]+)[\\s+,+]\\s*");
        }
        regexBuf.append("([\\d\\.eE\\+\\-]+)\\s*");
        this.recParser = new RegexParser(regexBuf.toString());
    }

    public static String[] guessFieldNames(String filename) throws FileNotFoundException, IOException {
        int fieldCount = AsciiParser.guessFieldCount(filename);
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return fieldNames;
    }

    public static int guessFieldCount(String filename) throws FileNotFoundException, IOException {
        String line;
        int maxFieldCount = 10;
        int[] recCount = new int[10];
        StringBuffer regexBuf = new StringBuffer();
        regexBuf.append("\\s*([\\d\\.eE\\+\\-]+)");
        for (int i = 1; i < 10; ++i) {
            regexBuf.append("([\\s+,+]\\s*([\\d\\.eE\\+\\-]+))?");
        }
        regexBuf.append("\\s*");
        Pattern pat = Pattern.compile(regexBuf.toString());
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        block1: while ((line = ((BufferedReader)reader).readLine()) != null) {
            Matcher m = pat.matcher(line);
            if (!m.matches()) continue;
            for (int j = 1; j < m.groupCount(); j += 2) {
                if (m.group(j) != null) continue;
                int n = (j - 1) / 2;
                recCount[n] = recCount[n] + 1;
                continue block1;
            }
        }
        int max = 0;
        int imax = 0;
        for (int j = 1; j < 10; ++j) {
            if (recCount[j] <= max) continue;
            imax = j;
            max = recCount[j];
        }
        return imax;
    }

    public FixedColumnsParser setFixedColumnsParser(String filename, String delim) throws IOException {
        int i;
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        String line = ((BufferedReader)reader).readLine();
        for (int i2 = 0; i2 < this.skipLines; ++i2) {
            line = ((BufferedReader)reader).readLine();
        }
        reader.close();
        int col = 0;
        String[] ss = line.split(delim);
        int[] columnOffsets = new int[ss.length];
        int[] columnWidths = new int[ss.length];
        boolean rightJustified = false;
        if (ss[0].trim().length() == 0) {
            rightJustified = true;
            for (i = 0; i < ss.length - 1; ++i) {
                ss[i] = ss[i + 1];
            }
        }
        columnOffsets[0] = 0;
        if (rightJustified) {
            for (i = 1; i < ss.length; ++i) {
                col = line.indexOf(ss[i - 1], columnOffsets[i - 1]);
                columnOffsets[i] = col + ss[i - 1].length();
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        } else {
            for (i = 1; i < ss.length; ++i) {
                columnOffsets[i] = col = line.indexOf(ss[i], col + ss[i - 1].length());
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        }
        FixedColumnsParser p = new FixedColumnsParser(columnOffsets, columnWidths);
        this.recParser = p;
        return p;
    }

    public static AsciiParser newParser(int fieldCount) {
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return new AsciiParser(fieldNames);
    }

    public static AsciiParser newParser(String[] fieldNames) {
        return new AsciiParser(fieldNames);
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public void setRecordCountLimit(int recordCountLimit) {
        this.recordCountLimit = recordCountLimit;
    }

    public void setPropertyPattern(Pattern propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    private DataSet readStream(InputStream in, DasProgressMonitor mon) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int iline = 0;
        int irec = 0;
        mon.started();
        DataSetBuilder builder = new DataSetBuilder(2, 100, this.fieldCount, 1);
        long bytesRead = 0L;
        while ((line = reader.readLine()) != null && !mon.isCancelled()) {
            ++iline;
            mon.setTaskProgress(bytesRead += (long)(line.length() + 1));
            try {
                Matcher m;
                if (iline < this.skipLines) continue;
                if (this.propertyPattern != null && (m = this.propertyPattern.matcher(line)).matches()) {
                    builder.putProperty(m.group(1).trim(), m.group(2).trim());
                    continue;
                }
                if (!this.recParser.tryParseRecord(line, irec, builder)) continue;
                ++irec;
                builder.nextRecord();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        mon.finished();
        return builder.getDataSet();
    }

    public DataSet readFile(String filename, DasProgressMonitor mon) throws IOException {
        long size = new File(filename).length();
        mon.setTaskSize(size);
        return this.readStream(new FileInputStream(filename), mon);
    }

    public static void main(String[] args) throws Exception {
        String file = "L:/ct/virbo/autoplot/data/2490lintest90005.dat";
        AsciiParser parser = AsciiParser.newParser(5);
        parser.setPropertyPattern(Pattern.compile("\\s*(.+)\\s*\\:\\s*(.+)\\s*"));
        long t0 = System.currentTimeMillis();
        DataSet ds = parser.readFile(file, DasProgressMonitor.NULL);
        System.out.println("" + (System.currentTimeMillis() - t0));
        System.out.println(ds.property("Frequency"));
        System.out.flush();
    }

    public AsciiParser() {
    }

    public final class FixedColumnsParser
    implements RecordParser {
        int[] columnOffsets;
        int[] columnWidths;

        public FixedColumnsParser(int[] columnOffsets, int[] columnWidths) {
            this.columnOffsets = columnOffsets;
            this.columnWidths = columnWidths;
        }

        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            for (int i = 0; i < AsciiParser.this.fieldCount; ++i) {
                try {
                    double d = Double.parseDouble(line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]));
                    builder.putValue(irec, i, d);
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.err.println("error parsing line " + irec + ": " + line);
                }
            }
            return true;
        }
    }

    public final class RegexParser
    implements RecordParser {
        Pattern recordPattern;

        public RegexParser(String regex) {
            this.recordPattern = Pattern.compile(regex);
        }

        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            Matcher m;
            if (this.recordPattern != null && (m = this.recordPattern.matcher(line)).matches()) {
                try {
                    int i;
                    boolean allInvalid = true;
                    for (i = 0; i < AsciiParser.this.fieldCount; ++i) {
                        try {
                            double d = Double.parseDouble(m.group(i + 1));
                            allInvalid = false;
                            continue;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (!allInvalid) {
                        for (i = 0; i < AsciiParser.this.fieldCount; ++i) {
                            builder.putValue(irec, i, AsciiParser.this.units[i].parse(m.group(i + 1)).doubleValue(AsciiParser.this.units[i]));
                        }
                        return true;
                    }
                    return false;
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            return false;
        }
    }

    public static interface RecordParser {
        public boolean tryParseRecord(String var1, int var2, DataSetBuilder var3);
    }
}

