/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeModel;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.dsutil.AsciiParser;
import org.virbo.metatree.NameValueTreeModel;

public class AsciiTableDataSource
extends AbstractDataSource {
    AsciiParser parser;
    File file;
    String column = "field0";
    String depend0 = null;
    DDataSet ds = null;
    int[] rank2 = null;

    public AsciiTableDataSource(URL url) throws FileNotFoundException, IOException {
        super(url);
    }

    public DataSet getDataSet(DasProgressMonitor mon) throws IOException {
        this.ds = this.doReadFile(mon);
        DataSet vds = null;
        DataSet dep0 = null;
        for (int i = 0; i < this.ds.length(0); ++i) {
            if (("field" + i).equals(this.column)) {
                vds = DataSetOps.slice1((DataSet)this.ds, (int)i);
            }
            if (!("field" + i).equals(this.depend0)) continue;
            dep0 = DataSetOps.slice1((DataSet)this.ds, (int)i);
        }
        if (dep0 != null) {
            this.ds.putProperty("DEPEND_0", dep0);
        }
        if (this.rank2 != null) {
            return this.ds;
        }
        if (vds == null) {
            throw new IllegalArgumentException("didn't find column: " + this.column);
        }
        return vds;
    }

    private DDataSet doReadFile(DasProgressMonitor mon) throws NumberFormatException, IOException, FileNotFoundException {
        Map params = DataSetURL.parseParams(this.url.getQuery());
        this.file = DataSetURL.getFile(this.url, mon);
        int columnCount = 0;
        Object o = params.get("fixedColumns");
        if (o != null) {
            columnCount = Integer.parseInt((String)o);
        }
        o = params.get("columnCount");
        if (columnCount == 0) {
            columnCount = o != null ? Integer.parseInt((String)o) : AsciiParser.guessFieldCount((String)this.file.toString());
        }
        this.parser = AsciiParser.newParser((int)columnCount);
        this.parser.setPropertyPattern(AsciiParser.NAME_COLON_VALUE_PATTERN);
        o = params.get("skip");
        if (o != null) {
            this.parser.setSkipLines(Integer.parseInt((String)o));
        }
        if ((o = params.get("fixedColumns")) != null) {
            this.parser.setFixedColumnsParser(this.file.toString(), "\\s+");
            this.parser.setPropertyPattern(null);
        }
        if ((o = params.get("column")) != null) {
            this.column = (String)o;
        }
        if ((o = params.get("depend0")) != null) {
            this.depend0 = (String)o;
        }
        if ((o = params.get("rank2")) != null) {
            this.rank2 = new int[]{0, columnCount};
        }
        DDataSet ds = (DDataSet)this.parser.readFile(this.file.toString(), mon);
        return ds;
    }

    public static DataSourceFactory getFactory() {
        return new DataSourceFactory(){

            public DataSource getDataSource(URL url) throws FileNotFoundException, IOException {
                return new AsciiTableDataSource(url);
            }

            public String[] getCompletions(String surl) throws MalformedURLException, FileNotFoundException, IOException {
                File file = DataSetURL.getFile(DataSetURL.getURL(surl), DasProgressMonitor.NULL);
                String[] result = new String[]{DataSetURL.getURL(file.toString()) + "?skip=0&column=field0&fixedColumns=2"};
                return result;
            }
        };
    }

    public TreeModel getMetaData() throws Exception {
        if (this.ds == null) {
            return NameValueTreeModel.create("no metadata", new HashMap());
        }
        Map props = this.ds.getProperties();
        NameValueTreeModel retValue = NameValueTreeModel.create("metadata", props);
        return retValue;
    }
}

