/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import java.util.ArrayList;
import java.util.HashMap;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSet;

public class DataSetBuilder {
    int rank;
    ArrayList<DDataSet> finished;
    DDataSet current;
    int recCount;
    int dim1;
    int dim2;
    int index;
    int offset;
    HashMap<String, Object> properties;

    public DataSetBuilder(int rank, int recCount, int dim1, int dim2) {
        this.rank = rank;
        this.recCount = recCount;
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.newCurrent();
        this.index = 0;
        this.properties = new HashMap();
    }

    private void newCurrent() {
        if (this.rank == 1) {
            this.current = DDataSet.createRank1((int)this.recCount);
        } else if (this.rank == 2) {
            this.current = DDataSet.createRank2((int)this.recCount, (int)this.dim1);
        } else if (this.rank == 3) {
            this.current = DDataSet.createRank3((int)this.recCount, (int)this.dim1, (int)this.dim2);
        }
    }

    public void putValue(int index0, double d) {
        this.current.putValue(this.index, d);
    }

    public void putValue(int index0, int index1, double d) {
        this.current.putValue(this.index, index1, d);
    }

    public void putValue(int index0, int index1, int index2, double d) {
        this.current.putValue(this.index, index1, index2, d);
    }

    public void nextRecord() {
        ++this.index;
        if (this.index == this.current.length()) {
            if (this.finished == null) {
                this.finished = new ArrayList(4);
            }
            this.finished.add(this.current);
            this.offset += this.current.length();
            this.index -= this.current.length();
            this.newCurrent();
        }
    }

    public DataSet getDataSet() {
        DDataSet result;
        switch (this.rank) {
            case 1: {
                result = DDataSet.createRank1((int)(this.index + this.offset));
                break;
            }
            case 2: {
                result = DDataSet.createRank2((int)(this.index + this.offset), (int)this.dim1);
                break;
            }
            case 3: {
                result = DDataSet.createRank3((int)(this.index + this.offset), (int)this.dim1, (int)this.dim2);
                break;
            }
            default: {
                throw new RuntimeException("bad rank");
            }
        }
        int dsindex = 0;
        if (this.finished != null) {
            for (int i = 0; i < this.finished.size(); ++i) {
                DDataSet f1 = this.finished.get(i);
                DDataSet.copyElements((DDataSet)f1, (int)0, (DDataSet)result, (int)dsindex, (int)f1.length());
                dsindex += f1.length();
            }
            DDataSet.copyElements((DDataSet)this.current, (int)0, (DDataSet)result, (int)dsindex, (int)this.index);
        } else {
            result = DDataSet.copy((DataSet)this.current);
        }
        result.putLength(this.index + this.offset);
        for (String key : this.properties.keySet()) {
            result.putProperty(key, this.properties.get(key));
        }
        return result;
    }

    public void putProperty(String string, Object o) {
        this.properties.put(string, o);
    }
}

