/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.IOException;
import java.net.URL;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.virbo.dataset.DataSet;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;

public abstract class AbstractDataSource
implements DataSource {
    protected URL url;

    public AbstractDataSource(URL url) {
        this.url = url;
    }

    public abstract DataSet getDataSet(DasProgressMonitor var1) throws Exception;

    public boolean asynchronousLoad() {
        return true;
    }

    public DatumRange getXRange() {
        return DatumRange.newDatumRange((double)0.0, (double)100.0, (Units)Units.dimensionless);
    }

    public DatumRange getYRange() {
        return DatumRange.newDatumRange((double)0.0, (double)100.0, (Units)Units.dimensionless);
    }

    public String getLabel() {
        return this.url.toString();
    }

    public String toString() {
        return this.url.toString();
    }

    public String getURL() {
        return this.url.toString();
    }

    public DataSourceFactory getFactory() {
        try {
            return DataSetURL.getDataSourceFactory(this.url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TreeModel getMetaData() throws Exception {
        final String ROOT = "(no metadata provided)";
        return new TreeModel(){

            public Object getRoot() {
                return ROOT;
            }

            public Object getChild(Object parent, int index) {
                return null;
            }

            public int getChildCount(Object parent) {
                return 0;
            }

            public boolean isLeaf(Object node) {
                return node != ROOT;
            }

            public void valueForPathChanged(TreePath path, Object newValue) {
            }

            public int getIndexOfChild(Object parent, Object child) {
                return 0;
            }

            public void addTreeModelListener(TreeModelListener l) {
            }

            public void removeTreeModelListener(TreeModelListener l) {
            }
        };
    }
}

