/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetSelector
extends JPanel {
    Runnable completionsRunnable = null;
    DasProgressMonitor completionsMonitor = null;
    JPopupMenu completionsPopupMenu = null;
    private JButton browseButton;
    private JComboBox dataSetSelector;
    private JButton plotItButton;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String browseTypeExt;
    private transient ArrayList actionListenerList;
    private List<String> recent;

    public DataSetSelector() {
        this.initComponents();
        this.addCompletionKeys();
        this.dataSetSelector.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                System.err.println(e);
                System.err.println("  " + e.getModifiers());
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void showCompletions() {
        final String surl = (String)this.dataSetSelector.getEditor().getItem();
        if (surl.contains("?")) {
            if (this.completionsRunnable != null) {
                System.err.println("cancel existing completion task");
                this.completionsMonitor.cancel();
                this.completionsRunnable = null;
            }
            this.completionsMonitor = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor("getting completions", "getting completions by delegate");
            this.completionsRunnable = new Runnable(){

                public void run() {
                    String[] completions;
                    DataSetSelector.this.completionsPopupMenu = new JPopupMenu();
                    try {
                        completions = DataSetURL.getCompletions(surl, DataSetSelector.this.completionsMonitor);
                    }
                    catch (Exception ex) {
                        completions = new String[]{ex.getClass().getName(), ex.getMessage()};
                    }
                    for (int i = 0; i < completions.length; ++i) {
                        final String comp1 = completions[i];
                        DataSetSelector.this.completionsPopupMenu.add(new AbstractAction(completions[i]){

                            public void actionPerformed(ActionEvent ev) {
                                DataSetSelector.this.dataSetSelector.setSelectedItem(comp1);
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DataSetSelector.this.completionsPopupMenu.show(DataSetSelector.this.dataSetSelector, 0, 0);
                            DataSetSelector.this.completionsRunnable = null;
                        }
                    });
                }
            };
            new Thread(this.completionsRunnable, "completionsThread").start();
        } else {
            try {
                JPopupMenu popupMenu = new JPopupMenu();
                DasProgressMonitor mon = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor("getting completions", "getting remote listing");
                DataSetURL.URLSplit split = DataSetURL.parse(surl);
                System.err.println(split);
                FileSystem fs = FileSystem.create((URL)new URL(split.path));
                String prefix = split.file.substring(split.path.length());
                String surlDir = split.path;
                String[] s = fs.listDirectory("/");
                boolean foldCase = Boolean.TRUE.equals(fs.getProperty("caseInsensitive"));
                if (foldCase) {
                    prefix = prefix.toLowerCase();
                }
                ArrayList<String> completions = new ArrayList<String>(s.length);
                for (int j = 0; j < s.length; ++j) {
                    String scomp;
                    String string = scomp = foldCase ? s[j].toLowerCase() : s[j];
                    if (!scomp.startsWith(prefix)) continue;
                    if (s[j].endsWith("contents.html")) {
                        s[j] = s[j].substring(0, s[j].length() - "contents.html".length());
                    }
                    completions.add(surlDir + s[j]);
                }
                for (int i = 0; i < completions.size(); ++i) {
                    final String comp1 = (String)completions.get(i);
                    popupMenu.add(new AbstractAction((String)completions.get(i)){

                        public void actionPerformed(ActionEvent ev) {
                            DataSetSelector.this.dataSetSelector.setSelectedItem(comp1);
                        }
                    });
                }
                popupMenu.show(this.dataSetSelector, 0, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addCompletionKeys() {
        ActionMap map = this.dataSetSelector.getActionMap();
        map.put("complete", new AbstractAction("completionsPopup"){

            public void actionPerformed(ActionEvent ev) {
                DataSetSelector.this.showCompletions();
            }
        });
        map.put("plot", new AbstractAction("plotUrl"){

            public void actionPerformed(ActionEvent ev) {
                ActionEvent e = new ActionEvent(this, 123, "dataSetSelect");
                DataSetSelector.this.fireActionListenerActionPerformed(e);
            }
        });
        this.dataSetSelector.setActionMap(map);
        InputMap imap = this.dataSetSelector.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(32, 2), "complete");
        imap.put(KeyStroke.getKeyStroke(10, 2), "plot");
        imap.put(KeyStroke.getKeyStroke(80, 2), "plot");
        this.dataSetSelector.setInputMap(0, imap);
    }

    private void initComponents() {
        this.browseButton = new JButton();
        this.plotItButton = new JButton();
        this.dataSetSelector = new JComboBox();
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/file.png")));
        this.browseButton.setToolTipText("browse for resource");
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.browseButtonActionPerformed(evt);
            }
        });
        this.plotItButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/go.png")));
        this.plotItButton.setToolTipText("plot this URL");
        this.plotItButton.setMargin(new Insets(0, 0, 0, 0));
        this.plotItButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.plotItButtonActionPerformed(evt);
            }
        });
        this.dataSetSelector.setEditable(true);
        this.dataSetSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/genesis/3dl2_gim/2003/genesis_3dl2_gim_20030501_v01.cdf.dds?Proton_Density", "file://C:/iowaCitySales2004-2006.latlong.xls?column=M[1:]", "file://c:/Documents and Settings/jbf/My Documents/xx.d2s", "L:/fun/realEstate/to1960.latlon.xls?column=C[1:]&depend0=H[1:]", "L:/fun/realEstate/to1960.latlon.xls?column=M[1:]&depend0=N[1:]&plane0=C[1:]", "L:/ct/virbo/autoplot/data/610008002FE00410.20060901.das2Stream", "P:/poes/poes_n15_20060212.nc?proton-6_dome_16_MeV", "L:/ct/virbo/autoplot/data/asciiTab.dat", "L:/ct/virbo/autoplot/data/2490lintest90005.dat"}));
        this.dataSetSelector.setToolTipText("enter data source URL");
        this.dataSetSelector.setMinimumSize(new Dimension(20, 20));
        this.dataSetSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.dataSetSelectorActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dataSetSelector, 0, 665, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.plotItButton, -2, 23, -2).addPreferredGap(0).add((Component)this.browseButton)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dataSetSelector, -2, -1, -2).add((Component)this.plotItButton, -2, 25, -2).add((Component)this.browseButton)));
    }

    private void dataSetSelectorActionPerformed(ActionEvent evt) {
    }

    private void plotItButtonActionPerformed(ActionEvent evt) {
        ActionEvent e = new ActionEvent(this, 123, "dataSetSelect");
        this.fireActionListenerActionPerformed(e);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String context = (String)this.dataSetSelector.getSelectedItem();
        try {
            URL url = Util.newURL(new URL("file://"), context);
            if (url.getProtocol().equals("file")) {
                JFileChooser chooser = new JFileChooser(url.getPath());
                int result = chooser.showOpenDialog(this);
                if (result == 0) {
                    this.dataSetSelector.setSelectedItem(chooser.getSelectedFile());
                }
            } else {
                this.showCompletions();
            }
        }
        catch (MalformedURLException e) {
            DasExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getValue() {
        return (String)this.dataSetSelector.getSelectedItem();
    }

    public void setValue(String value) {
        String oldValue = this.getValue();
        this.dataSetSelector.setSelectedItem(value);
        this.propertyChangeSupport.firePropertyChange("value", oldValue, value);
    }

    public String getBrowseTypeExt() {
        return this.browseTypeExt;
    }

    public void setBrowseTypeExt(String browseTypeExt) {
        String oldBrowseTypeExt = this.browseTypeExt;
        this.browseTypeExt = browseTypeExt;
        this.propertyChangeSupport.firePropertyChange("browseTypeExt", oldBrowseTypeExt, browseTypeExt);
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionListenerActionPerformed(ActionEvent event) {
        ArrayList list;
        DataSetSelector dataSetSelector = this;
        synchronized (dataSetSelector) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (ArrayList)this.actionListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(event);
        }
    }

    public List<String> getRecent() {
        return this.recent;
    }

    public void setRecent(List<String> recent) {
        List<String> oldRecent = this.recent;
        this.recent = recent;
        this.dataSetSelector.setModel(new DefaultComboBoxModel<Object>(recent.toArray()));
        this.propertyChangeSupport.firePropertyChange("recent", oldRecent, recent);
    }
}

