/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.virbo.datasource.DataSourceFactory;

public class DataSourceRegistry {
    private static DataSourceRegistry instance;
    HashMap dataSourcesByExt = new HashMap();
    HashMap dataSourcesByMime = new HashMap();

    private DataSourceRegistry() {
    }

    public static DataSourceRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceRegistry();
        }
        return instance;
    }

    public void register(DataSourceFactory factory, String extension) {
        this.dataSourcesByExt.put(extension, factory);
    }

    public void register(DataSourceFactory factory, String extension, String mime) {
        this.dataSourcesByExt.put(extension, factory);
        this.dataSourcesByMime.put(mime.toLowerCase(), factory);
    }

    public void register(String className, String extension) {
        this.dataSourcesByExt.put(extension, className);
    }

    public void register(String className, String extension, String mime) {
        this.dataSourcesByExt.put(extension, className);
        this.dataSourcesByMime.put(mime.toLowerCase(), className);
    }

    public DataSourceFactory getSource(String extension) {
        DataSourceFactory result;
        Object o = this.dataSourcesByExt.get(extension);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceFactory)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFactory)o;
        }
        return result;
    }

    public DataSourceFactory getSourceByMime(String mime) {
        DataSourceFactory result;
        Object o = this.dataSourcesByMime.get(mime.toLowerCase());
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceFactory)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFactory)o;
        }
        return result;
    }
}

