/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dods;

import dods.dap.BaseType;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DConnect;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DGrid;
import dods.dap.DODSException;
import dods.dap.Float32PrimitiveVector;
import dods.dap.NoSuchVariableException;
import dods.dap.PrimitiveVector;
import dods.dap.StatusUI;
import dods.dap.parser.ParseException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.TableDataSetAdapter;
import org.virbo.dataset.VectorDataSetAdapter;
import org.virbo.dods.DodsVarDataSet;

public class DodsAdapter {
    private URL source;
    private String variable;
    private String constraint;
    private DDS dds;
    private HashMap properties;
    int sliceIndex = 0;
    private String depend0Name;
    private String depend1Name;
    private double addOffset = 0.0;
    private double scaleFactor = 1.0;
    private Units[] dimUnits = new Units[8];
    private HashMap[] dimProperties = new HashMap[8];
    private Units units;
    private String[] dependName = new String[8];

    public DodsAdapter(URL source, String variable) {
        this.source = source;
        this.variable = this.doEscapes(variable);
        this.properties = new HashMap();
    }

    private String doEscapes(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '%') {
                result.append(ch);
                continue;
            }
            String s2 = Integer.toHexString(ch);
            result.append("%" + s2.substring(s2.length() - 2));
        }
        return result.toString();
    }

    public void setConstraint(String c) {
        if (!c.startsWith("?")) {
            throw new IllegalArgumentException("constraint must start with question mark(?)");
        }
        this.constraint = c;
    }

    private long getSizeForType(DArray v) {
        PrimitiveVector pv = v.getPrimitiveVector();
        if (pv instanceof Float32PrimitiveVector) {
            return 4L;
        }
        return 1L;
    }

    private long calcSize() throws MalformedURLException, IOException, ParseException {
        try {
            DDS dds = new DDS();
            dds.parse(new URL(this.getSource().toString() + ".dds" + this.constraint).openStream());
            Enumeration variables = dds.getVariables();
            long size = -1L;
            while (variables.hasMoreElements()) {
                DArray v = (DArray)variables.nextElement();
                Enumeration dimensions = v.getDimensions();
                long s1 = this.getSizeForType(v);
                System.err.println("Sizeoftype=" + s1);
                System.err.println("Sizeoftype=" + (s1 *= 2L));
                while (dimensions.hasMoreElements()) {
                    DArrayDimension d = (DArrayDimension)dimensions.nextElement();
                    s1 *= (long)d.getSize();
                }
                size += s1;
            }
            return size;
        }
        catch (DDSException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadDataset(final DasProgressMonitor mon) throws FileNotFoundException, MalformedURLException, IOException, ParseException, DDSException, DODSException {
        if (this.constraint == null) {
            throw new IllegalArgumentException("constraint not set");
        }
        long size = this.calcSize();
        mon.setTaskSize(size);
        DConnect url = new DConnect(this.source.toString(), true);
        StatusUI sui = new StatusUI(){
            long byteCount = 0L;

            public void incrementByteCount(int bytes) {
                this.byteCount += (long)bytes;
                mon.setTaskProgress(this.byteCount);
            }

            public boolean userCancelled() {
                return mon.isCancelled();
            }

            public void finished() {
                mon.finished();
            }
        };
        mon.started();
        this.dds = url.getData(this.constraint, sui);
    }

    public void setSliceIndex(int index) {
        this.sliceIndex = index;
    }

    public org.virbo.dataset.DataSet getDataSet() {
        int j;
        DDataSet reduce;
        DodsVarDataSet zds;
        block15: {
            try {
                BaseType btvar = this.dds.getVariable(this.variable);
                String type = btvar.getTypeName();
                if (type.equals("Grid")) {
                    DGrid zgrid = (DGrid)btvar;
                    DArray z = (DArray)zgrid.getVar(0);
                    zds = DodsVarDataSet.newDataSet(z, this.properties);
                    zds.putProperty("UNITS", this.units);
                    for (int idim = 0; idim < z.numDimensions(); ++idim) {
                        DArray t = (DArray)zgrid.getVar(idim + 1);
                        HashMap<String, Units> tprops = new HashMap<String, Units>();
                        tprops.put("UNITS", this.dimUnits[idim]);
                        if (this.dimProperties[idim] != null) {
                            tprops.putAll(this.dimProperties[idim]);
                        }
                        DodsVarDataSet tds = DodsVarDataSet.newDataSet(t, tprops);
                        zds.putProperty("DEPEND_" + idim, tds);
                    }
                    break block15;
                }
                if (type.equals("Array")) {
                    DArray z = (DArray)btvar;
                    zds = DodsVarDataSet.newDataSet(z, this.properties);
                    zds.putProperty("UNITS", this.units);
                    for (int idim = 0; idim < z.numDimensions(); ++idim) {
                        if (this.dependName[idim] == null) continue;
                        DArray t = (DArray)this.dds.getVariable(this.dependName[idim]);
                        HashMap<String, Units> tprops = new HashMap<String, Units>();
                        tprops.put("UNITS", this.dimUnits[idim]);
                        if (this.dimProperties[idim] != null) {
                            tprops.putAll(this.dimProperties[idim]);
                        }
                        DodsVarDataSet tds = DodsVarDataSet.newDataSet(t, tprops);
                        zds.putProperty("DEPEND_" + idim, tds);
                    }
                    break block15;
                }
                throw new IllegalStateException("not supported dds type:" + type);
            }
            catch (NoSuchVariableException ex) {
                throw new RuntimeException(ex);
            }
        }
        DodsVarDataSet ds = zds;
        if (zds.rank() == 3) {
            reduce = DDataSet.createRank2((int)zds.length(), (int)zds.length(0));
            for (int i = 0; i < zds.length(); ++i) {
                for (j = 0; j < zds.length(0); ++j) {
                    reduce.putValue(i, j, zds.value(i, j, 0));
                }
            }
            ds = reduce;
        } else if (zds.rank() == 4) {
            reduce = DDataSet.createRank2((int)zds.length(), (int)zds.length(0));
            for (int i = 0; i < zds.length(); ++i) {
                for (j = 0; j < zds.length(0); ++j) {
                    reduce.putValue(i, j, zds.value(i, j, 0, 0));
                }
            }
            ds = reduce;
        }
        return ds;
    }

    public DataSet getDas2DataSet() {
        org.virbo.dataset.DataSet ds = this.getDataSet();
        if (ds.rank() == 3) {
            org.virbo.dataset.DataSet sliceDs = DataSetOps.slice0((org.virbo.dataset.DataSet)ds, (int)this.sliceIndex);
            return TableDataSetAdapter.create((org.virbo.dataset.DataSet)sliceDs);
        }
        if (ds.rank() == 2) {
            return TableDataSetAdapter.create((org.virbo.dataset.DataSet)ds);
        }
        return VectorDataSetAdapter.create((org.virbo.dataset.DataSet)ds);
    }

    public String getDepend0Name() {
        return this.depend0Name;
    }

    public void setDepend0Name(String depend0Name) {
        this.depend0Name = depend0Name;
    }

    public String getDepend1Name() {
        return this.depend1Name;
    }

    public void setDepend1Name(String depend1Name) {
        this.depend1Name = depend1Name;
    }

    public double getAddOffset() {
        return this.addOffset;
    }

    public void setAddOffset(double addOffset) {
        this.addOffset = addOffset;
        this.properties.put("add_offset", new Double(addOffset));
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.properties.put("scale_factor", new Double(scaleFactor));
    }

    public void setValidRange(double min, double max) {
        this.properties.put("valid_range", "" + min + "," + max);
    }

    public Units getDimUnits(int index) {
        return this.dimUnits[index];
    }

    public void setDimUnits(int index, Units dimUnits) {
        this.dimUnits[index] = dimUnits;
    }

    public void putAllProperties(Map p) {
        this.properties.putAll(p);
    }

    public void setDimProperties(int dim, Map p) {
        this.dimProperties[dim] = new HashMap(p);
    }

    public HashMap getDimProperties(int i) {
        return this.dimProperties[i];
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public String getDependName(int index) {
        return this.dependName[index];
    }

    public void setDependName(int index, String dependName) {
        this.dependName[index] = dependName;
    }

    public URL getSource() {
        return this.source;
    }

    public String getVariable() {
        return this.variable;
    }
}

