/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dods;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.parser.ParseException;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.TreeModel;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.dods.DodsAdapter;
import org.virbo.dods.DodsDataSourceFactory;
import org.virbo.dods.MyDASParser;
import org.virbo.dods.MyDDSParser;
import org.virbo.metatree.NameValueTreeModel;

public class DodsDataSource
extends AbstractDataSource {
    DodsAdapter adapter;
    String variable;
    String sMyUrl;
    String constraint;

    public DodsDataSource(URL url) throws IOException {
        super(url);
        this.parseUrl();
        try {
            URL myUrl = new URL(this.sMyUrl);
            this.adapter = new DodsAdapter(myUrl, this.variable);
            if (this.constraint != null) {
                this.adapter.setConstraint(this.constraint);
            }
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void parseUrl() {
        String surl = this.url.toString();
        int i = surl.lastIndexOf(46);
        this.sMyUrl = surl.substring(0, i);
        i = surl.indexOf(63);
        this.variable = surl.substring(i + 1);
        int ib = this.variable.indexOf(91);
        if (ib != -1) {
            this.constraint = "?" + this.variable;
            this.variable = this.variable.substring(0, ib);
        }
    }

    public DataSet getDataSet(DasProgressMonitor mon) throws FileNotFoundException, MalformedURLException, IOException, ParseException, DDSException, DODSException {
        MyDDSParser parser = new MyDDSParser();
        parser.parse(new URL(this.adapter.getSource().toString() + ".dds").openStream());
        if (this.constraint == null) {
            StringBuffer constraint = new StringBuffer("?");
            constraint.append(this.adapter.getVariable());
            if (!this.adapter.getVariable().contains("[")) {
                int[] ii = parser.getRecDims(this.adapter.getVariable());
                for (int i = 0; i < ii.length; ++i) {
                    constraint.append("[0:1:" + ii[i] + "]");
                }
            }
            this.adapter.setConstraint(constraint.toString());
        }
        this.adapter.loadDataset(mon);
        WritableDataSet ds = (WritableDataSet)this.adapter.getDataSet();
        return ds;
    }

    public boolean asynchronousLoad() {
        return true;
    }

    public static DataSourceFactory getFactory() {
        return new DodsDataSourceFactory();
    }

    public TreeModel getMetaData() throws IOException, ParseException, DASException {
        MyDASParser parser = new MyDASParser();
        parser.parse(new URL(this.adapter.getSource().toString() + ".das").openStream());
        DAS result = parser.getDAS();
        AttributeTable at = result.getAttributeTable(this.adapter.getVariable());
        if (at == null) {
            return NameValueTreeModel.create("variable metadata", new HashMap());
        }
        Enumeration n = at.getNames();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        while (n.hasMoreElements()) {
            Object key = n.nextElement();
            Attribute att = at.getAttribute((String)key);
            names.add(att.getName());
            values.add(att.getValueAt(0));
        }
        return NameValueTreeModel.create("variable metadata", names, values);
    }
}

