/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.excel;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;

public class ExcelSpreadsheetDataSource
extends AbstractDataSource {
    POIFSFileSystem fs;
    HSSFSheet sheet;
    ExcelSpreadsheetDataSet data;

    public ExcelSpreadsheetDataSource(URL url) throws IOException {
        super(url);
    }

    public DataSet getDataSet(DasProgressMonitor mon) throws IOException {
        ExcelSpreadsheetDataSet depend0;
        File file = DataSetURL.getFile(this.url, mon);
        FileInputStream in = new FileInputStream(file);
        this.fs = new POIFSFileSystem((InputStream)in);
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        this.sheet = wb.getSheetAt(0);
        String query = this.url.getQuery();
        Map m = DataSetURL.parseParams(query);
        String d = (String)m.get("column");
        this.data = this.createDataSet(d);
        d = (String)m.get("depend0");
        if (d != null) {
            depend0 = this.createDataSet(d);
            this.data.putProperty("DEPEND_0", depend0);
        }
        if ((d = (String)m.get("plane0")) != null) {
            depend0 = this.createDataSet(d);
            this.data.putProperty("PLANE_0", depend0);
        }
        return this.data;
    }

    private ExcelSpreadsheetDataSet createDataSet(String spec) {
        int lastRow;
        int firstRow;
        Pattern p = Pattern.compile("([A-Z]+)(\\[(\\d+):(\\d+)?\\])?");
        Matcher m = p.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad spec!");
        }
        String col = m.group(1);
        short columnNumber = (short)(col.charAt(0) - 65);
        if (m.group(3) == null) {
            firstRow = 0;
            lastRow = this.sheet.getLastRowNum();
        } else {
            firstRow = Integer.parseInt(m.group(3));
            lastRow = m.group(4) == null ? this.sheet.getLastRowNum() : Integer.parseInt(m.group(4));
        }
        return new ExcelSpreadsheetDataSet(columnNumber, firstRow, lastRow);
    }

    public static DataSourceFactory getFactory() {
        return new DataSourceFactory(){

            public DataSource getDataSource(URL url) throws IOException {
                return new ExcelSpreadsheetDataSource(url);
            }

            public String[] getCompletions(String surl) {
                return new String[0];
            }
        };
    }

    class ExcelSpreadsheetDataSet
    implements DataSet {
        short columnNumber;
        int firstRow;
        int length;
        Map properties = new HashMap();

        ExcelSpreadsheetDataSet(short columnNumber, int firstRow, int lastRow) {
            this.columnNumber = columnNumber;
            this.firstRow = firstRow;
            this.length = lastRow - firstRow;
            HSSFCell cell = ExcelSpreadsheetDataSource.this.sheet.getRow(firstRow).getCell(columnNumber);
            System.err.println(cell.getCellType());
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            HSSFRow row = null;
            HSSFCell cell = null;
            try {
                row = ExcelSpreadsheetDataSource.this.sheet.getRow(i + this.firstRow);
                cell = row.getCell(this.columnNumber);
                return cell.getNumericCellValue();
            }
            catch (RuntimeException e) {
                String cellID = String.valueOf((char)(65 + this.columnNumber)) + (this.firstRow + i);
                return -1.0E31;
            }
        }

        public double value(int i0, int i1) {
            throw new IllegalArgumentException("rank");
        }

        public double value(int i0, int i1, int i2) {
            throw new IllegalArgumentException("rank");
        }

        public Object property(String name) {
            return this.properties.get(name);
        }

        public Object property(String name, int i) {
            return this.properties.get(name);
        }

        public Object property(String name, int i0, int i1) {
            return this.properties.get(name);
        }

        public void putProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        public int length() {
            return this.length;
        }

        public int length(int i) {
            throw new IllegalArgumentException("ranklimit");
        }

        public int length(int i, int j) {
            throw new IllegalArgumentException("ranklimit");
        }

        public String toString() {
            return DataSetUtil.toString((DataSet)this);
        }
    }
}

