/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.metatree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NameValueTreeModel
implements TreeModel {
    final Object root;
    List nodes;

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.nodes.get(index);
        }
        PropertyNode p = (PropertyNode)parent;
        return p.getChild(index);
    }

    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.nodes.size();
        }
        PropertyNode p = (PropertyNode)parent;
        return p.childCount();
    }

    public boolean isLeaf(Object parent) {
        if (parent == this.root) {
            return false;
        }
        if (parent instanceof PropertyNode) {
            PropertyNode p = (PropertyNode)parent;
            return p.isLeaf();
        }
        return true;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public NameValueTreeModel(Object root, List nodes) {
        this.nodes = nodes;
        this.root = root;
    }

    public static NameValueTreeModel create(Object root, List names, List values) {
        ArrayList<PropertyNode> nodes = new ArrayList<PropertyNode>(names.size());
        for (int i = 0; i < names.size(); ++i) {
            nodes.add(new PropertyNode((String)names.get(i), String.valueOf(values.get(i))));
        }
        return new NameValueTreeModel(root, nodes);
    }

    public static NameValueTreeModel create(Object root, Map map) {
        ArrayList<PropertyNode> nodes = new ArrayList<PropertyNode>(map.size());
        for (Object key : map.keySet()) {
            nodes.add(new PropertyNode((String)key, String.valueOf(map.get(key))));
        }
        return new NameValueTreeModel(root, nodes);
    }

    public String toString() {
        return String.valueOf(this.root) + "(" + this.nodes.size() + "key/value pairs)";
    }

    static class PropertyNode {
        String name;
        String value;
        boolean hasKids;

        PropertyNode(String name, String value) {
            this.name = name;
            this.value = value;
            this.hasKids = value.length() > 50;
        }

        public String toString() {
            if (!this.hasKids) {
                return "" + this.name + "=" + this.value;
            }
            return "" + this.name + "=" + this.value.substring(0, 50) + " ...";
        }

        public int childCount() {
            return this.hasKids ? this.value.length() / 50 + 1 : 0;
        }

        public Object getChild(int i) {
            int i0;
            int i1 = Math.min((i + 1) * 50, this.value.length());
            for (i0 = i * 50; i0 > 0 && i0 < this.value.length() && !Character.isWhitespace(this.value.charAt(i0 - 1)); ++i0) {
            }
            while (i1 < this.value.length() && !Character.isWhitespace(this.value.charAt(i1))) {
                ++i1;
            }
            return this.value.substring(i0, i1);
        }

        public boolean isLeaf() {
            return !this.hasKids;
        }
    }
}

