/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.virbo.dataset.DataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.netCDF.NetCDFDataSourceFactory;
import org.virbo.netCDF.NetCdfVarDataSet;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCDFDataSource
extends AbstractDataSource {
    Variable variable;
    String sMyUrl;
    String svariable;

    public NetCDFDataSource(URL url) throws IOException {
        super(url);
        System.err.println("URL=" + url);
        this.parseUrl();
    }

    private void parseUrl() {
        String surl = this.url.toString();
        int i = surl.lastIndexOf(63);
        this.sMyUrl = surl.substring(0, i);
        i = surl.indexOf(63);
        this.svariable = surl.substring(i + 1);
    }

    public DataSet getDataSet(DasProgressMonitor mon) throws IOException {
        System.err.println(this.sMyUrl);
        NetcdfFile f = NetcdfFile.open((String)this.sMyUrl);
        NetcdfDataset dataset = new NetcdfDataset(f);
        List variables = dataset.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            Variable v = (Variable)variables.get(i);
            if (!v.getName().equals(this.svariable)) continue;
            this.variable = v;
        }
        return new NetCdfVarDataSet(this.variable);
    }

    public boolean asynchronousLoad() {
        return true;
    }

    public static DataSourceFactory getFactory() {
        return new NetCDFDataSourceFactory();
    }
}

