/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dods.SPDFUtil;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class NetCdfVarDataSet
extends AbstractDataSet {
    Variable v;
    double[] data;

    public NetCdfVarDataSet(Variable variable) throws IOException {
        this.v = variable;
        Array a = this.v.read();
        this.data = (double[])a.get1DJavaArray(Double.class);
        Dimension d = this.v.getDimension(0);
        List l = d.getCoordinateVariables();
        if (l.size() > 1) {
            throw new IllegalArgumentException("Huh?");
        }
        for (int i = 0; i < l.size(); ++i) {
            Variable dv = (Variable)l.get(0);
            if (dv == variable) continue;
            NetCdfVarDataSet depend0 = new NetCdfVarDataSet(dv);
            this.properties.put("DEPEND_0", depend0);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        List attrs = this.v.getAttributes();
        for (Attribute attr : attrs) {
            if (attr.isArray()) continue;
            if (attr.isString()) {
                attributes.put(attr.getName(), attr.getStringValue());
                continue;
            }
            attributes.put(attr.getName(), String.valueOf(attr.getNumericValue()));
        }
        Map p = SPDFUtil.interpretProps(attributes);
        this.properties.putAll(p);
        DatumRange dr = (DatumRange)this.properties.get("VALID_RANGE");
        if (dr != null) {
            Units u = dr.getUnits();
            double vmin = dr.min().doubleValue(u);
            double vmax = dr.max().doubleValue(u);
            for (int i = 0; i < this.data.length; ++i) {
                if (!(this.data[i] <= vmin) && !(this.data[i] >= vmax)) continue;
                this.data[i] = u.getFillDouble();
            }
        }
    }

    public int rank() {
        return this.v.getRank();
    }

    public double value(int i) {
        return this.data[i];
    }

    public int length() {
        return this.data.length;
    }
}

