/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.spase;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.tree.TreeModel;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.parsers.DOMParser;
import org.virbo.dataset.DataSet;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSource;
import org.virbo.spase.DOMTreeWalkerTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SpaseRecordDataSource
implements DataSource {
    URL url;
    Document document;
    DataSource delegate;

    public SpaseRecordDataSource(URL url) throws IllegalArgumentException, IOException, SAXException, Exception {
        this.url = url;
        this.readXML();
        String surl = null;
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            surl = this.findSurl();
            this.delegate = DataSetURL.getDataSource(new URL(surl));
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("unable to get /Spase/NumericalData/AccessInformation/AccessURL/URL(): " + ex.getMessage());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Spase record AccessURL is malformed: " + surl);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    private String findSurl() {
        String[] lookFor = new String[]{"Spase", "NumericalData", "AccessInformation", "AccessURL", "URL"};
        NodeList list = this.document.getElementsByTagName(lookFor[0]);
        Element pos = (Element)list.item(0);
        for (int i = 1; i < lookFor.length; ++i) {
            list = pos.getElementsByTagName(lookFor[i]);
            pos = (Element)list.item(0);
        }
        String result = null;
        list = pos.getChildNodes();
        for (int k = 0; k < list.getLength(); ++k) {
            Node child = list.item(k);
            if (child.getNodeType() != 3) continue;
            result = child.getNodeValue();
        }
        return result;
    }

    public DataSet getDataSet(DasProgressMonitor mon) throws Exception {
        return this.delegate.getDataSet(mon);
    }

    public boolean asynchronousLoad() {
        return this.delegate.asynchronousLoad();
    }

    public DatumRange getXRange() {
        return this.delegate.getXRange();
    }

    public DatumRange getYRange() {
        return this.delegate.getYRange();
    }

    public String getLabel() {
        return this.delegate.getLabel();
    }

    private void readXML() throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.url.openStream()));
        InputSource input = new InputSource(in);
        parser.parse(input);
        this.document = parser.getDocument();
    }

    public TreeModel getMetaData() throws Exception {
        DocumentTraversal traversal = (DocumentTraversal)((Object)this.document);
        NodeFilter filter = new NodeFilter(){

            public short acceptNode(Node n) {
                if (n.getNodeType() == 3 && ((Text)n).getData().trim().length() == 0) {
                    return 2;
                }
                return 1;
            }
        };
        int whatToShow = -129;
        TreeWalker walker = traversal.createTreeWalker(this.document, whatToShow, filter, false);
        return new DOMTreeWalkerTreeModel(walker);
    }

    public String getURL() {
        return this.url.toString();
    }
}

